/*
 * Decompiled with CFR 0.152.
 */
package com.kizitonwose.calendarview.ui;

import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import com.kizitonwose.calendarview.CalendarView;
import com.kizitonwose.calendarview.model.CalendarDay;
import com.kizitonwose.calendarview.model.DayOwner;
import com.kizitonwose.calendarview.model.ScrollMode;
import com.kizitonwose.calendarview.ui.CalendarAdapter;
import com.kizitonwose.calendarview.ui.CalendarConfig;
import com.kizitonwose.calendarview.ui.MonthViewHolder;
import com.kizitonwose.calendarview.utils.ExtensionsKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.threeten.bp.LocalDate;
import org.threeten.bp.YearMonth;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/kizitonwose/calendarview/ui/CalendarLayoutManager;", "Landroidx/recyclerview/widget/LinearLayoutManager;", "calView", "Lcom/kizitonwose/calendarview/CalendarView;", "config", "Lcom/kizitonwose/calendarview/ui/CalendarConfig;", "(Lcom/kizitonwose/calendarview/CalendarView;Lcom/kizitonwose/calendarview/ui/CalendarConfig;)V", "adapter", "Lcom/kizitonwose/calendarview/ui/CalendarAdapter;", "getAdapter", "()Lcom/kizitonwose/calendarview/ui/CalendarAdapter;", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "calculateOffset", "", "day", "Lcom/kizitonwose/calendarview/model/CalendarDay;", "itemView", "Landroid/view/View;", "scrollToDate", "", "date", "Lorg/threeten/bp/LocalDate;", "scrollToMonth", "month", "Lorg/threeten/bp/YearMonth;", "smoothScrollToDate", "smoothScrollToMonth", "CalendarSmoothScroller", "library_release"})
public final class CalendarLayoutManager
extends LinearLayoutManager {
    private final CalendarView calView;
    private final CalendarConfig config;

    @NotNull
    public final CalendarAdapter getAdapter() {
        RecyclerView.Adapter adapter = this.calView.getAdapter();
        if (adapter == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.kizitonwose.calendarview.ui.CalendarAdapter");
        }
        return (CalendarAdapter)adapter;
    }

    @NotNull
    public final Context getContext() {
        Context context = this.calView.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"calView.context");
        return context;
    }

    public final void scrollToMonth(@NotNull YearMonth month) {
        Intrinsics.checkParameterIsNotNull((Object)month, (String)"month");
        this.scrollToPosition(this.getAdapter().getAdapterPosition$library_release(month));
    }

    public final void smoothScrollToMonth(@NotNull YearMonth month) {
        Intrinsics.checkParameterIsNotNull((Object)month, (String)"month");
        int position = this.getAdapter().getAdapterPosition$library_release(month);
        if (position != -1) {
            this.startSmoothScroll((RecyclerView.SmoothScroller)new CalendarSmoothScroller(position, null));
        }
    }

    public final void smoothScrollToDate(@NotNull LocalDate date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        int position = this.getAdapter().getAdapterPosition$library_release(ExtensionsKt.getYearMonth(date));
        if (position != -1) {
            this.startSmoothScroll((RecyclerView.SmoothScroller)new CalendarSmoothScroller(position, date));
        }
    }

    public final void scrollToDate(@NotNull LocalDate date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        this.scrollToMonth(ExtensionsKt.getYearMonth(date));
        if (this.config.getScrollMode() == ScrollMode.PAGED) {
            return;
        }
        this.calView.post(new Runnable(this, date){
            final /* synthetic */ CalendarLayoutManager this$0;
            final /* synthetic */ LocalDate $date;

            public final void run() {
                CalendarDay day = new CalendarDay(this.$date, DayOwner.THIS_MONTH);
                int monthPosition = this.this$0.getAdapter().getAdapterPosition$library_release(ExtensionsKt.getYearMonth(this.$date));
                if (monthPosition != -1) {
                    RecyclerView.ViewHolder viewHolder = CalendarLayoutManager.access$getCalView$p(this.this$0).findViewHolderForAdapterPosition(monthPosition);
                    if (viewHolder == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.kizitonwose.calendarview.ui.MonthViewHolder");
                    }
                    MonthViewHolder viewHolder2 = (MonthViewHolder)viewHolder;
                    View view = viewHolder2.itemView;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"viewHolder.itemView");
                    int offset = CalendarLayoutManager.access$calculateOffset(this.this$0, day, view);
                    this.this$0.scrollToPositionWithOffset(monthPosition, -offset);
                }
            }
            {
                this.this$0 = calendarLayoutManager;
                this.$date = localDate;
            }
        });
    }

    private final int calculateOffset(CalendarDay day, View itemView) {
        View view = itemView.findViewById(day.getDate().hashCode());
        if (view == null) {
            return 0;
        }
        View dayView = view;
        Rect rect = new Rect();
        dayView.getDrawingRect(rect);
        View view2 = itemView;
        if (view2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ((ViewGroup)view2).offsetDescendantRectToMyCoords(dayView, rect);
        return this.getOrientation() == 1 ? rect.top + this.calView.getMonthMarginTop() : rect.left + this.calView.getMonthMarginStart();
    }

    public CalendarLayoutManager(@NotNull CalendarView calView, @NotNull CalendarConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)calView), (String)"calView");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(calView.getContext(), config.getOrientation(), false);
        this.calView = calView;
        this.config = config;
    }

    public static final /* synthetic */ CalendarView access$getCalView$p(CalendarLayoutManager $this) {
        return $this.calView;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0014J\b\u0010\u000f\u001a\u00020\u0003H\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/kizitonwose/calendarview/ui/CalendarLayoutManager$CalendarSmoothScroller;", "Landroidx/recyclerview/widget/LinearSmoothScroller;", "position", "", "date", "Lorg/threeten/bp/LocalDate;", "(Lcom/kizitonwose/calendarview/ui/CalendarLayoutManager;ILorg/threeten/bp/LocalDate;)V", "getDate", "()Lorg/threeten/bp/LocalDate;", "calculateDxToMakeVisible", "view", "Landroid/view/View;", "snapPreference", "calculateDyToMakeVisible", "getHorizontalSnapPreference", "getVerticalSnapPreference", "library_release"})
    private final class CalendarSmoothScroller
    extends LinearSmoothScroller {
        @Nullable
        private final LocalDate date;

        protected int getVerticalSnapPreference() {
            return -1;
        }

        protected int getHorizontalSnapPreference() {
            return -1;
        }

        public int calculateDyToMakeVisible(@NotNull View view, int snapPreference) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            int dy = super.calculateDyToMakeVisible(view, snapPreference);
            if (this.date == null) {
                return dy;
            }
            int offset = CalendarLayoutManager.this.calculateOffset(new CalendarDay(this.date, DayOwner.THIS_MONTH), view);
            return dy - offset;
        }

        public int calculateDxToMakeVisible(@NotNull View view, int snapPreference) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            int dx = super.calculateDxToMakeVisible(view, snapPreference);
            if (this.date == null) {
                return dx;
            }
            int offset = CalendarLayoutManager.this.calculateOffset(new CalendarDay(this.date, DayOwner.THIS_MONTH), view);
            return dx - offset;
        }

        @Nullable
        public final LocalDate getDate() {
            return this.date;
        }

        public CalendarSmoothScroller(@Nullable int position, LocalDate date) {
            super(CalendarLayoutManager.this.getContext());
            this.date = date;
            this.setTargetPosition(position);
        }
    }
}

