package com.github.kittinunf.reactiveandroid.widget

import android.widget.SeekBar
import com.github.kittinunf.reactiveandroid.ExtensionFieldDelegate
import com.github.kittinunf.reactiveandroid.subscription.AndroidMainThreadSubscription
import io.reactivex.Observable

//================================================================================
// Events
//================================================================================

data class SeekBarProgressChangeListener(val seekBar: SeekBar?, val progress: Int, val fromUser: Boolean)

fun SeekBar.rx_progressChanged(): Observable<SeekBarProgressChangeListener> {
    return Observable.create { subscriber ->
        _seekBarChange.onProgressChanged { seekBar, progress, fromUser ->
            subscriber.onNext(SeekBarProgressChangeListener(seekBar, progress, fromUser))
        }

        subscriber.setDisposable(AndroidMainThreadSubscription {
            setOnSeekBarChangeListener(null)
        })
    }
}

fun SeekBar.rx_startTrackingTouch(): Observable<SeekBar> {
    return Observable.create { subscriber ->
        _seekBarChange.onStartTrackingTouch {
            if (it != null) subscriber.onNext(it)
        }

        subscriber.setDisposable(AndroidMainThreadSubscription {
            setOnSeekBarChangeListener(null)
        })
    }
}

fun SeekBar.rx_stopTrackingTouch(): Observable<SeekBar> {
    return Observable.create { subscriber ->
        _seekBarChange.onStopTrackingTouch {
            if (it != null) subscriber.onNext(it)
        }

        subscriber.setDisposable(AndroidMainThreadSubscription {
            setOnSeekBarChangeListener(null)
        })
    }
}

private val SeekBar._seekBarChange: _SeekBar_OnSeekBarChangeListener
        by ExtensionFieldDelegate({ _SeekBar_OnSeekBarChangeListener() }, { setOnSeekBarChangeListener(it) })

internal class _SeekBar_OnSeekBarChangeListener : SeekBar.OnSeekBarChangeListener {

    var onProgressChanged: ((SeekBar?, Int, Boolean) -> Unit)? = null

    var onStartTrackingTouch: ((SeekBar?) -> Unit)? = null

    var onStopTrackingTouch: ((SeekBar?) -> Unit)? = null

    fun onProgressChanged(listener: (SeekBar?, Int, Boolean) -> Unit) {
        onProgressChanged = listener
    }

    override fun onProgressChanged(seekBar: SeekBar?, progress: Int, fromUser: Boolean) {
        onProgressChanged?.invoke(seekBar, progress, fromUser)
    }

    fun onStartTrackingTouch(listener: (SeekBar?) -> Unit) {
        onStartTrackingTouch = listener
    }

    override fun onStartTrackingTouch(seekBar: SeekBar?) {
        onStartTrackingTouch?.invoke(seekBar)
    }

    fun onStopTrackingTouch(listener: (SeekBar?) -> Unit) {
        onStopTrackingTouch = listener
    }

    override fun onStopTrackingTouch(seekBar: SeekBar?) {
        onStopTrackingTouch?.invoke(seekBar)
    }

}



 
