/*
 * Decompiled with CFR 0.152.
 */
package ki.pagetransformer.sharedelement;

import android.app.Activity;
import android.graphics.Point;
import android.util.Pair;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.viewpager.widget.ViewPager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ki.pagetransformer.sharedelement.SePageTransformer;

public abstract class AbstractSePageTransformer
implements SePageTransformer {
    protected final Activity activity;
    protected final ViewPager viewPager;
    List<Fragment> fragments;
    protected Set<Pair<Integer, Integer>> sharedElementIds = new HashSet<Pair<Integer, Integer>>();
    protected List<View> pages = new ArrayList<View>();
    protected Map<View, Integer> pageToNumber = new HashMap<View, Integer>();
    protected Integer fromPageNumber = 0;
    protected Integer toPageNumber;
    protected Map<Integer, Float> idToAbsX = new HashMap<Integer, Float>();
    protected Map<Integer, Float> idToAbsY = new HashMap<Integer, Float>();
    private int position;

    public AbstractSePageTransformer(Activity activity, List<Fragment> fragments, ViewPager viewPager) {
        this.activity = activity;
        this.fragments = fragments;
        this.viewPager = viewPager;
    }

    public void transformPage(@NonNull View page, float position) {
        this.updatePageCache();
        if (this.fromPageNumber == null || this.toPageNumber == null) {
            return;
        }
        for (Pair<Integer, Integer> idPair : this.sharedElementIds) {
            Integer fromViewId = (Integer)idPair.first;
            Integer toViewId = (Integer)idPair.second;
            View fromView = this.activity.findViewById(fromViewId.intValue());
            View toView = this.activity.findViewById(toViewId.intValue());
            if (fromView == null || toView == null) continue;
            View fromPage = this.pages.get(this.fromPageNumber);
            View toPage = this.pages.get(this.toPageNumber);
            if (fromPage == null || toPage == null) continue;
            fromView = fromPage.findViewById(fromViewId.intValue());
            toView = toPage.findViewById(toViewId.intValue());
            if (fromView == null || toView == null) continue;
            boolean slideToTheRight = this.toPageNumber > this.fromPageNumber;
            this.modifyPositions(fromView, toView, fromPage, toPage, page, position, slideToTheRight);
        }
    }

    protected void modifyPositions(View fromView, View toView, View fromPage, View toPage, View currentPage, float position, boolean slideToTheRight) {
    }

    protected float getPageWidth() {
        Point outSize = new Point();
        this.activity.getWindowManager().getDefaultDisplay().getSize(outSize);
        return outSize.x;
    }

    private void updatePageCache() {
        this.pages = new ArrayList<View>();
        for (int i = 0; i < this.fragments.size(); ++i) {
            View pageView = this.fragments.get(i).getView();
            this.pages.add(pageView);
            this.pageToNumber.put(pageView, i);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        HashSet<Integer> visiblePages = new HashSet<Integer>();
        visiblePages.add(position);
        visiblePages.add(positionOffset >= 0.0f ? position + 1 : position - 1);
        visiblePages.remove(this.fromPageNumber);
        this.toPageNumber = (Integer)visiblePages.iterator().next();
        if (this.pages == null || this.toPageNumber >= this.pages.size()) {
            this.toPageNumber = null;
        }
    }

    public void onPageSelected(int position) {
        this.position = position;
    }

    public void onPageScrollStateChanged(int state) {
        if (state == 0) {
            this.fromPageNumber = this.position;
        }
    }

    @Override
    public void addTransition(int fromViewId, int toViewId) {
        this.addTransition(fromViewId, toViewId, true);
    }

    @Override
    public void addTransition(int fromViewId, int toViewId, boolean bothDirections) {
        this.sharedElementIds.add((Pair<Integer, Integer>)new Pair((Object)fromViewId, (Object)toViewId));
        if (bothDirections) {
            this.sharedElementIds.add((Pair<Integer, Integer>)new Pair((Object)toViewId, (Object)fromViewId));
        }
    }

    @Override
    public void removeTransition(int fromViewId, int toViewId, boolean bothDirections) {
        this.sharedElementIds.remove(new Pair((Object)fromViewId, (Object)toViewId));
        if (bothDirections) {
            this.sharedElementIds.remove(new Pair((Object)toViewId, (Object)fromViewId));
        }
    }

    @Override
    public void removeTransition(int fromViewId, int toViewId) {
        this.removeTransition(fromViewId, toViewId, true);
    }

    @Override
    public void clearAllTransitions() {
        this.sharedElementIds.clear();
    }
}

