/*
 * Decompiled with CFR 0.152.
 */
package net.kinguin.leadership.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.logging.Logger;
import net.kinguin.leadership.core.Member;
import net.kinguin.leadership.http.ElectionResponse;
import net.kinguin.leadership.http.config.HttpMemberProperties;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import rx.Observable;
import rx.subjects.PublishSubject;

public class HttpMember
implements Member {
    private static final Logger log = Logger.getLogger(HttpMember.class.getName());
    private final PublishSubject<Object> publisher = PublishSubject.create();
    private HttpMemberProperties properties;

    @Override
    public boolean isLeader() {
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(this.properties.getCheckUrl()).build();
        try {
            Response response = client.newCall(request).execute();
            if (!response.isSuccessful()) {
                response.close();
                throw new IOException();
            }
            ObjectMapper objectMapper = new ObjectMapper();
            ElectionResponse res = (ElectionResponse)objectMapper.readValue(response.body().string(), ElectionResponse.class);
            return res.getName().equals(this.properties.getNodeName());
        }
        catch (IOException e) {
            log.warning(String.format("Something went wrong with get leader. Cause %s", e.getMessage()));
            return false;
        }
    }

    @Override
    public Observable<Object> asObservable() {
        return this.publisher;
    }

    public HttpMember(HttpMemberProperties properties) {
        this.properties = properties;
    }
}

