/*
 * Decompiled with CFR 0.152.
 */
package net.kinguin.leadership.consul.election;

import com.ecwid.consul.v1.kv.KeyValueClient;
import com.ecwid.consul.v1.kv.model.GetValue;
import com.ecwid.consul.v1.kv.model.PutParams;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import net.kinguin.leadership.consul.config.ClusterConfiguration;
import net.kinguin.leadership.consul.election.Vote;
import net.kinguin.leadership.core.ElectionMessage;
import net.kinguin.leadership.core.Member;
import rx.Observable;
import rx.subjects.PublishSubject;

public class ConsulMember
implements Runnable,
Member {
    private KeyValueClient consulKVClient;
    private String sessionId;
    private ClusterConfiguration clusterConfiguration;
    private boolean gotLeadership = false;
    private boolean wasLeader = false;
    private PublishSubject<Object> publisher = PublishSubject.create();
    private String key;
    private ObjectMapper mapper = new ObjectMapper();

    public ConsulMember(KeyValueClient consulKVClient, String sessionId, ClusterConfiguration clusterConfiguration) {
        this.consulKVClient = consulKVClient;
        this.sessionId = sessionId;
        this.clusterConfiguration = clusterConfiguration;
        this.key = String.format(clusterConfiguration.getElection().getEnvelopeTemplate(), clusterConfiguration.getServiceName());
    }

    @Override
    public void run() {
        try {
            this.gotLeadership = this.vote();
        }
        catch (JsonProcessingException e) {
            this.gotLeadership = false;
            this.publish((Exception)((Object)e));
            return;
        }
        if (!this.gotLeadership) {
            this.publish("notelected");
            if (this.wasLeader) {
                this.publish("relegation");
                this.wasLeader = false;
            }
            return;
        }
        this.publish("elected");
        if (!this.wasLeader) {
            this.publish("elected.first");
            this.wasLeader = true;
        }
    }

    @Override
    public synchronized boolean isLeader() {
        return this.gotLeadership;
    }

    @Override
    public Observable<Object> asObservable() {
        return this.publisher;
    }

    private boolean vote() throws JsonProcessingException {
        PutParams params = new PutParams();
        params.setAcquireSession(this.sessionId);
        return (Boolean)this.consulKVClient.setKVValue(this.key, this.createVoteEnvelope(), params).getValue();
    }

    private String createVoteEnvelope() throws JsonProcessingException {
        Vote vote = new Vote();
        vote.sessionId = this.sessionId;
        vote.serviceName = this.clusterConfiguration.getServiceName();
        vote.serviceId = this.clusterConfiguration.getServiceId();
        return new ObjectMapper().writeValueAsString((Object)vote);
    }

    private Vote leaderLookup() throws IOException {
        String response = ((GetValue)this.consulKVClient.getKVValue(this.key).getValue()).getDecodedValue();
        return (Vote)this.mapper.readValue(response, Vote.class);
    }

    private void publish(String status) {
        ElectionMessage electionMessage = new ElectionMessage();
        electionMessage.status = status;
        try {
            electionMessage.vote = this.leaderLookup();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.publisher.onNext((Object)electionMessage);
    }

    private void publish(Exception e) {
        ElectionMessage electionMessage = new ElectionMessage();
        electionMessage.status = "error";
        electionMessage.error = e.getMessage();
        try {
            electionMessage.vote = this.leaderLookup();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.publisher.onNext((Object)electionMessage);
    }
}

