/*
 * Decompiled with CFR 0.152.
 */
package com.kvn.mockj.handler;

import com.alibaba.fastjson.JSONObject;
import com.kvn.mockj.Handler;
import com.kvn.mockj.Options;
import com.kvn.mockj.handler.TypeHandler;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ObjectHandler
implements TypeHandler {
    @Override
    public Class[] support() {
        return new Class[]{JSONObject.class};
    }

    @Override
    public Object handle(Options options) {
        JSONObject jo = new JSONObject();
        if (options.getRule().getMin() != null) {
            JSONObject template = (JSONObject)options.getTemplate();
            List keyList = template.keySet().parallelStream().collect(Collectors.toList());
            Collections.shuffle(keyList);
            int count = keyList.size() > options.getRule().getCount() ? options.getRule().getCount().intValue() : keyList.size();
            for (int i = 0; i < count; ++i) {
                String key = (String)keyList.get(i >= keyList.size() ? i - keyList.size() : i);
                String parsedKey = ObjectHandler.parseName(key);
                jo.put(parsedKey, Handler.gen(template.get((Object)key), key, options.getContext()));
            }
            return jo;
        }
        JSONObject template = (JSONObject)options.getTemplate();
        for (String key : template.keySet()) {
            String parsedKey = ObjectHandler.parseName(key);
            jo.put(parsedKey, Handler.gen(template.get((Object)key), key, options.getContext()));
        }
        return jo;
    }

    private static String parseName(String name) {
        int index = name.indexOf("|");
        return index < 0 ? name : name.substring(0, index);
    }
}

