#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.context;

import java.beans.PropertyEditorSupport;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import lombok.extern.log4j.Log4j2;
import org.springframework.util.StringUtils;

/**
 *
 * @author Kent Yeh
 */
@Log4j2
public class DatePropertyEditor extends PropertyEditorSupport {

    private static final Map<String, String> patterns = new HashMap<>();

    static {
        DatePropertyEditor.patterns.put("yyyyMMdd", "^${symbol_escape}${symbol_escape}d{8}${symbol_dollar}");
        DatePropertyEditor.patterns.put("yyyyMMddHHmmss", "^${symbol_escape}${symbol_escape}d{14}${symbol_dollar}");
        DatePropertyEditor.patterns.put("yyyy/M/d", "^${symbol_escape}${symbol_escape}d{4}/${symbol_escape}${symbol_escape}d{1,2}/${symbol_escape}${symbol_escape}d{1,2}${symbol_dollar}");
        DatePropertyEditor.patterns.put("yyyy/M/d H:m", "^${symbol_escape}${symbol_escape}d{4}/${symbol_escape}${symbol_escape}d{1,2}/${symbol_escape}${symbol_escape}d{1,2} ${symbol_escape}${symbol_escape}d{1,2}:${symbol_escape}${symbol_escape}d{1,2}${symbol_dollar}");
        DatePropertyEditor.patterns.put("yyyy/M/d H:m:s", "^${symbol_escape}${symbol_escape}d{4}/${symbol_escape}${symbol_escape}d{1,2}/${symbol_escape}${symbol_escape}d{1,2} ${symbol_escape}${symbol_escape}d{1,2}:${symbol_escape}${symbol_escape}d{1,2}:${symbol_escape}${symbol_escape}d{1,2}${symbol_dollar}");
        DatePropertyEditor.patterns.put("yyyy-M-d", "^${symbol_escape}${symbol_escape}d{4}-${symbol_escape}${symbol_escape}d{1,2}-${symbol_escape}${symbol_escape}d{1,2}${symbol_dollar}");
        DatePropertyEditor.patterns.put("yyyy-M-d H:m", "^${symbol_escape}${symbol_escape}d{4}-${symbol_escape}${symbol_escape}d{1,2}-${symbol_escape}${symbol_escape}d{1,2} ${symbol_escape}${symbol_escape}d{1,2}:${symbol_escape}${symbol_escape}d{1,2}${symbol_dollar}");
        DatePropertyEditor.patterns.put("yyyy-M-d H:m:s", "^${symbol_escape}${symbol_escape}d{4}-${symbol_escape}${symbol_escape}d{1,2}-${symbol_escape}${symbol_escape}d{1,2} ${symbol_escape}${symbol_escape}d{1,2}:${symbol_escape}${symbol_escape}d{1,2}:${symbol_escape}${symbol_escape}d{1,2}${symbol_dollar}");
    }

    @Override
    public String getAsText() {
        return getValue() == null ? "" : String.format("%1${symbol_dollar}tY/%1${symbol_dollar}tm/%1${symbol_dollar}td", getValue());
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (!StringUtils.hasText(text)) {
            setValue(null);
        } else if (text instanceof String) {
            Object dateObj = null;
            SimpleDateFormat df = new SimpleDateFormat();
            for (Map.Entry<String, String> entry : DatePropertyEditor.patterns.entrySet()) {
                if (text.matches(entry.getValue())) {
                    df.applyPattern(entry.getKey());
                    try {
                        dateObj = df.parse(text);
                    } catch (Exception e) {
                        log.error(String.format("轉換日期%s[%s]失敗", text, entry.getKey()), e.getMessage(), e);
                    }
                    break;
                }
            }
            setValue(dateObj);
        } else {
            setValue(null);
        }
    }
}
