/*
 * Decompiled with CFR 0.152.
 */
package scpc.model.support;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import scpc.model.IChainRule;
import scpc.model.IRule;
import scpc.model.SingleItem;
import scpc.model.support.EvalHelper;

public abstract class SpelEvalHelper<T>
extends EvalHelper<T> {
    private static final Logger logger = LoggerFactory.getLogger(SpelEvalHelper.class);
    private static final EvaluationContext context = new StandardEvaluationContext();
    private static final SpelExpressionParser sep = new SpelExpressionParser(new SpelParserConfiguration(true, true));
    private static final Pattern escapePtn = Pattern.compile("[\\\\\\^\\$\\.\\|\\?\\*\\+\\(\\)\\[\\{]");
    private BindHolder binder = null;
    private IRule<T> bindRule = null;
    private SingleItem<T> bindItem = null;

    public Expression getExpression(String spel) {
        return sep.parseExpression(spel);
    }

    private String escape(String src) {
        Matcher m = escapePtn.matcher(src);
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        while (m.find()) {
            sb.append(src.substring(pos, m.start())).append("\\").append(src.substring(m.start(), m.start() + 1));
            pos = m.start() + 1;
        }
        return sb.append(src.substring(pos, src.length())).toString();
    }

    @Override
    public EvalHelper<T> bindVaribles(IRule<T> rule, SingleItem<T> item) {
        this.binder = new BindHolder<T>(rule, item);
        this.bindRule = rule;
        this.bindItem = item;
        return this;
    }

    @Override
    public EvalHelper<T> bindVarValue(String variable, Object value) {
        return this;
    }

    @Override
    public <R> R eval(String formula) throws ScriptException {
        String varname;
        if (this.binder == null) {
            throw new ScriptException("Not any binder bind (IRule,SingleItem) yet");
        }
        HashMap<String, String> prefix = new HashMap<String, String>();
        HashMap<String, String> replacers = new HashMap<String, String>();
        String rpfx = "";
        String rrpfx = "rule";
        for (IChainRule<T> prule = this.bindRule.getPrevious(); prule != null; prule = prule.getPrevious()) {
            rpfx = rpfx + this.getPreviousRulePrefix();
            rrpfx = rrpfx + ".previous";
            prefix.put(rpfx, rrpfx);
        }
        for (Map.Entry entry : prefix.entrySet()) {
            String varname2 = SpelEvalHelper.validJSVarName((String)entry.getKey() + this.getVarContainsCount());
            if (null != replacers.put(varname2, (String)entry.getValue() + ".containsCount")) {
                throw new ScriptException(String.format(" 2.Variable[%s] already set!", varname2));
            }
            varname2 = SpelEvalHelper.validJSVarName((String)entry.getKey() + this.getVarSumOfContainsOriginalPrice());
            if (null != replacers.put(varname2, (String)entry.getValue() + ".sumOfContainsOriginalPrice")) {
                throw new ScriptException(String.format(" 3.Variable[%s] already set!", varname2));
            }
            varname2 = SpelEvalHelper.validJSVarName((String)entry.getKey() + this.getVarSumOfContainsSalePrice());
            if (null != replacers.put(varname2, (String)entry.getValue() + ".sumOfContainsSalePrice")) {
                throw new ScriptException(String.format(" 4.Variable[%s] already set!", varname2));
            }
            varname2 = SpelEvalHelper.validJSVarName((String)entry.getKey() + this.getVarSumOfSerialOriginalPrice());
            if (null != replacers.put(varname2, (String)entry.getValue() + ".sumOfSerialOriginalPrice")) {
                throw new ScriptException(String.format(" 5.Variable[%s] already set!", varname2));
            }
            varname2 = SpelEvalHelper.validJSVarName((String)entry.getKey() + this.getVarSumOfSerialSalePrice());
            if (null == replacers.put(varname2, (String)entry.getValue() + ".sumOfSerialSalePrice")) continue;
            throw new ScriptException(String.format(" 6.Variable[%s] already set!", varname2));
        }
        if (this.bindRule != null) {
            varname = SpelEvalHelper.validJSVarName(this.getVarContainsCount());
            if (null != replacers.put(varname, "rule.containsCount")) {
                throw new ScriptException(String.format(" 8.Variable[%s] already set!", varname));
            }
            varname = SpelEvalHelper.validJSVarName(this.getVarSumOfContainsOriginalPrice());
            if (null != replacers.put(varname, "rule.sumOfContainsOriginalPrice")) {
                throw new ScriptException(String.format(" 9.Variable[%s] already set!", varname));
            }
            varname = SpelEvalHelper.validJSVarName(this.getVarSumOfContainsSalePrice());
            if (null != replacers.put(varname, "rule.sumOfContainsSalePrice")) {
                throw new ScriptException(String.format("10.Variable[%s] already set!", varname));
            }
            varname = SpelEvalHelper.validJSVarName(this.getVarSumOfSerialOriginalPrice());
            if (null != replacers.put(varname, "rule.sumOfSerialOriginalPrice")) {
                throw new ScriptException(String.format("11,Variable[%s] already set!", varname));
            }
            varname = SpelEvalHelper.validJSVarName(this.getVarSumOfSerialSalePrice());
            if (null != replacers.put(varname, "rule.sumOfSerialSalePrice")) {
                throw new ScriptException(String.format("12.Variable[%s] already set!", varname));
            }
        }
        if (this.bindItem != null) {
            varname = SpelEvalHelper.validJSVarName(this.getVarSalePrice());
            if (null != replacers.put(varname, "item.salePrice")) {
                throw new ScriptException(String.format("13.Variable[%s] already set!", varname));
            }
            varname = SpelEvalHelper.validJSVarName(this.getVarOriginalPrice());
            if (null != replacers.put(varname, "item.originalPrice")) {
                throw new ScriptException(String.format("14.Variable[%s] already set!", varname));
            }
            varname = SpelEvalHelper.validJSVarName(this.getVarSerialNum());
            if (null != replacers.put(varname, "item.serialNum")) {
                throw new ScriptException(String.format("15.Variable[%s] already set!", varname));
            }
        }
        Matcher m = JS_NAME_LOCATOR.matcher(formula);
        int pos = 0;
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            String rep = (String)replacers.get(m.group());
            if (rep != null) {
                sb.append(formula.substring(pos, m.start())).append(rep);
            }
            pos = m.end();
        }
        formula = sb.append(formula.substring(pos)).toString();
        logger.debug("Spel.eval(\"{}\")", (Object)formula);
        Expression exp = sep.parseExpression(formula);
        return (R)exp.getValue(context, (Object)this.binder);
    }

    @Override
    protected void purgeBind() {
        this.binder = null;
        this.bindRule = null;
        this.bindItem = null;
    }

    private static class BindHolder<T> {
        private final IRule<T> rule;
        private final SingleItem<T> item;

        public BindHolder(IRule<T> rule, SingleItem<T> item) {
            this.rule = rule;
            this.item = item;
        }

        public IRule<T> getRule() {
            return this.rule;
        }

        public SingleItem<T> getItem() {
            return this.item;
        }
    }
}

