/*
 * Decompiled with CFR 0.152.
 */
package scpc.model.support;

import java.math.BigDecimal;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scpc.model.IChainRule;
import scpc.model.IRule;
import scpc.model.SingleItem;
import scpc.model.support.EvalHelper;

public abstract class AbstractRuleBase<T>
implements IRule<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRuleBase.class);
    private int containsCount = 0;
    private BigDecimal containsSumOfOriginalPrice = BigDecimal.ZERO;
    private BigDecimal containsSumOfSalePrice = BigDecimal.ZERO;
    private BigDecimal sumOfSerialOriginalPrice = BigDecimal.ZERO;
    private BigDecimal serialSumOfSalePrice = BigDecimal.ZERO;
    private IChainRule<T> previousRule = null;
    private String triggerFormula = "";
    private String quantityFormula = "";
    private EvalHelper evalHelper = null;

    public String getTriggerFormula() {
        return this.triggerFormula;
    }

    public void setTriggerFormula(String triggerFormula) {
        this.triggerFormula = triggerFormula;
    }

    public String getQuantityFormula() {
        return this.isLeaf() ? this.quantityFormula : null;
    }

    public void setQuantityFormula(String quantityFormula) {
        this.quantityFormula = quantityFormula;
    }

    @Override
    public IChainRule<T> getPrevious() {
        return this.previousRule;
    }

    public void setPrevious(IChainRule<T> previousRule) {
        this.previousRule = previousRule;
    }

    @Override
    public IRule<T> containsCountInc() {
        ++this.containsCount;
        return this;
    }

    @Override
    public int getContainsCount() {
        return this.containsCount;
    }

    @Override
    public IRule<T> sumOfContainsOriginalPriceInc(BigDecimal originalPrice) {
        this.containsSumOfOriginalPrice = this.containsSumOfOriginalPrice.add(originalPrice);
        return this;
    }

    @Override
    public IRule<T> sumOfContainsSalePriceInc(BigDecimal salePrice) {
        this.containsSumOfSalePrice = this.containsSumOfSalePrice.add(salePrice.setScale(this.getPriceScale()));
        return this;
    }

    @Override
    public BigDecimal getSumOfContainsOriginalPrice() {
        return this.containsSumOfOriginalPrice;
    }

    @Override
    public BigDecimal getSumOfContainsSalePrice() {
        return this.containsSumOfSalePrice;
    }

    @Override
    public BigDecimal getSumOfSerialOriginalPrice() {
        return this.sumOfSerialOriginalPrice;
    }

    @Override
    public BigDecimal getSumOfSerialSalePrice() {
        return this.serialSumOfSalePrice;
    }

    public void setSerialSumOfSalePrice(BigDecimal serialSumOfSalePrice) {
        this.serialSumOfSalePrice = serialSumOfSalePrice;
    }

    @Override
    public IRule<T> sumOfSerialOriginalPriceInc(BigDecimal saleprice) {
        this.sumOfSerialOriginalPrice = this.sumOfSerialOriginalPrice.add(saleprice.setScale(this.getPriceScale()));
        return this;
    }

    @Override
    public IRule<T> sumOfSerialSalePriceInc(BigDecimal saleprice) {
        this.serialSumOfSalePrice = this.serialSumOfSalePrice.add(saleprice.setScale(this.getPriceScale()));
        return this;
    }

    @Override
    public IRule<T> resetSumOfSerialOriginalPrice() {
        this.sumOfSerialOriginalPrice = BigDecimal.ZERO;
        return this;
    }

    @Override
    public IRule<T> resetSumOfSerialSalePrice() {
        this.serialSumOfSalePrice = BigDecimal.ZERO;
        return this;
    }

    @Override
    public void resetSumOfPrice() {
        this.containsSumOfOriginalPrice = BigDecimal.ZERO;
        this.containsSumOfSalePrice = BigDecimal.ZERO;
        this.sumOfSerialOriginalPrice = BigDecimal.ZERO;
        this.serialSumOfSalePrice = BigDecimal.ZERO;
    }

    public EvalHelper getEvalHelper() {
        return this.evalHelper;
    }

    public void setEvalHelper(EvalHelper evalHelper) {
        this.evalHelper = evalHelper;
    }

    @Override
    public boolean isTriggered(SingleItem<T> item) throws ScriptException {
        if (this.contains(item)) {
            if (this.evalHelper == null) {
                throw new RuntimeException("Not any evalHelper already setting yet!");
            }
            boolean res = Boolean.TRUE.equals(this.evalHelper.bindVaribles(this, item).eval(this.getTriggerFormula()));
            logger.debug("eval(\"{}\") = {}", (Object)this.getTriggerFormula(), (Object)res);
            return res;
        }
        logger.debug("not triggered owing not counts");
        return false;
    }

    public double evalQuantity() throws ScriptException {
        if (this.isLeaf()) {
            if (this.evalHelper == null) {
                throw new RuntimeException("Not any evalHelper already setting yet!");
            }
            Number mb = (Number)this.evalHelper.eval(this.getQuantityFormula());
            logger.debug("evail quantity(\"{}\")={}", (Object)this.getQuantityFormula(), (Object)mb);
            return mb.doubleValue();
        }
        return 0.0;
    }
}

