/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen.javase;

import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import net.glxn.qrgen.core.AbstractQRCode;
import net.glxn.qrgen.core.exception.QRGenerationException;
import net.glxn.qrgen.core.image.ImageType;
import net.glxn.qrgen.core.scheme.Schema;
import net.glxn.qrgen.javase.MatrixToSvgWriter;

public class QRCode
extends AbstractQRCode {
    public static final MatrixToImageConfig DEFAULT_CONFIG = new MatrixToImageConfig();
    protected final String text;
    protected MatrixToImageConfig matrixToImageConfig = DEFAULT_CONFIG;

    protected QRCode(String text) {
        this.text = text;
        this.qrWriter = new QRCodeWriter();
    }

    public static QRCode from(String text) {
        return new QRCode(text);
    }

    public static QRCode from(Schema schema) {
        return new QRCode(schema.generateString());
    }

    public QRCode to(ImageType imageType) {
        this.imageType = imageType;
        return this;
    }

    public QRCode withSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public QRCode withCharset(String charset) {
        return this.withHint(EncodeHintType.CHARACTER_SET, charset);
    }

    public QRCode withErrorCorrection(ErrorCorrectionLevel level) {
        return this.withHint(EncodeHintType.ERROR_CORRECTION, level);
    }

    public QRCode withHint(EncodeHintType hintType, Object value) {
        this.hints.put(hintType, value);
        return this;
    }

    public File file() {
        File file;
        try {
            file = this.createTempFile();
            MatrixToImageWriter.writeToPath((BitMatrix)this.createMatrix(this.text), (String)this.imageType.toString(), (Path)file.toPath(), (MatrixToImageConfig)this.matrixToImageConfig);
        }
        catch (Exception e) {
            throw new QRGenerationException("Failed to create QR image from text due to underlying exception", (Throwable)e);
        }
        return file;
    }

    public File file(String name) {
        File file;
        try {
            file = this.createTempFile(name);
            MatrixToImageWriter.writeToPath((BitMatrix)this.createMatrix(this.text), (String)this.imageType.toString(), (Path)file.toPath(), (MatrixToImageConfig)this.matrixToImageConfig);
        }
        catch (Exception e) {
            throw new QRGenerationException("Failed to create QR image from text due to underlying exception", (Throwable)e);
        }
        return file;
    }

    protected void writeToStream(OutputStream stream) throws IOException, WriterException {
        MatrixToImageWriter.writeToStream((BitMatrix)this.createMatrix(this.text), (String)this.imageType.toString(), (OutputStream)stream, (MatrixToImageConfig)this.matrixToImageConfig);
    }

    public File svg() {
        File file;
        try {
            file = this.createTempSvgFile();
            MatrixToSvgWriter.writeToPath(this.createMatrix(this.text), file.toPath(), this.matrixToImageConfig);
        }
        catch (Exception e) {
            throw new QRGenerationException("Failed to create QR svg from text due to underlying exception", (Throwable)e);
        }
        return file;
    }

    public File svg(String name) {
        File file;
        try {
            file = this.createTempSvgFile(name);
            MatrixToSvgWriter.writeToPath(this.createMatrix(this.text), file.toPath(), this.matrixToImageConfig);
        }
        catch (Exception e) {
            throw new QRGenerationException("Failed to create QR svg from text due to underlying exception", (Throwable)e);
        }
        return file;
    }

    public void svg(OutputStream outs) {
        try {
            MatrixToSvgWriter.writeToStream(this.createMatrix(this.text), outs, this.matrixToImageConfig);
        }
        catch (Exception e) {
            throw new QRGenerationException("Failed to create QR svg from text due to underlying exception", (Throwable)e);
        }
    }

    private File createTempSvgFile() throws IOException {
        return this.createTempSvgFile("QRCode");
    }

    private File createTempSvgFile(String name) throws IOException {
        File file = File.createTempFile(name, ".svg");
        file.deleteOnExit();
        return file;
    }

    public QRCode withColor(int onColor, int offColor) {
        this.matrixToImageConfig = new MatrixToImageConfig(onColor, offColor);
        return this;
    }
}

