/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen.android;

import android.graphics.Bitmap;
import android.util.Log;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class BmpUtil {
    private static final int BMP_WIDTH_OF_TIMES = 4;
    private static final int BYTE_PER_PIXEL = 3;

    public static boolean save(Bitmap image, OutputStream stream) throws IOException {
        long start = System.currentTimeMillis();
        if (image == null) {
            return false;
        }
        if (stream == null) {
            return false;
        }
        boolean isSaveSuccess = true;
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] dummyBytesPerRow = null;
        boolean hasDummy = false;
        int rowWidthInBytes = 3 * width;
        if (rowWidthInBytes % 4 > 0) {
            hasDummy = true;
            dummyBytesPerRow = new byte[4 - rowWidthInBytes % 4];
            for (int i = 0; i < dummyBytesPerRow.length; ++i) {
                dummyBytesPerRow[i] = -1;
            }
        }
        int[] pixels = new int[width * height];
        int imageSize = (rowWidthInBytes + (hasDummy ? dummyBytesPerRow.length : 0)) * height;
        int imageDataOffset = 54;
        int fileSize = imageSize + imageDataOffset;
        image.getPixels(pixels, 0, width, 0, 0, width, height);
        ByteBuffer buffer = ByteBuffer.allocate(fileSize);
        buffer.put((byte)66);
        buffer.put((byte)77);
        buffer.put(BmpUtil.writeInt(fileSize));
        buffer.put(BmpUtil.writeShort((short)0));
        buffer.put(BmpUtil.writeShort((short)0));
        buffer.put(BmpUtil.writeInt(imageDataOffset));
        buffer.put(BmpUtil.writeInt(40));
        buffer.put(BmpUtil.writeInt(width + (hasDummy ? (dummyBytesPerRow.length == 3 ? 1 : 0) : 0)));
        buffer.put(BmpUtil.writeInt(height));
        buffer.put(BmpUtil.writeShort((short)1));
        buffer.put(BmpUtil.writeShort((short)24));
        buffer.put(BmpUtil.writeInt(0));
        buffer.put(BmpUtil.writeInt(imageSize));
        buffer.put(BmpUtil.writeInt(0));
        buffer.put(BmpUtil.writeInt(0));
        buffer.put(BmpUtil.writeInt(0));
        buffer.put(BmpUtil.writeInt(0));
        int row = height;
        int col = width;
        int startPosition = (row - 1) * col;
        int endPosition = row * col;
        while (row > 0) {
            for (int i = startPosition; i < endPosition; ++i) {
                buffer.put((byte)(pixels[i] & 0xFF));
                buffer.put((byte)((pixels[i] & 0xFF00) >> 8));
                buffer.put((byte)((pixels[i] & 0xFF0000) >> 16));
            }
            if (hasDummy) {
                buffer.put(dummyBytesPerRow);
            }
            --row;
            endPosition = startPosition;
            startPosition -= col;
        }
        stream.write(buffer.array());
        stream.close();
        Log.v((String)"BmpUtil", (String)(System.currentTimeMillis() - start + " ms"));
        return isSaveSuccess;
    }

    private static byte[] writeInt(int value) throws IOException {
        byte[] b = new byte[]{(byte)(value & 0xFF), (byte)((value & 0xFF00) >> 8), (byte)((value & 0xFF0000) >> 16), (byte)((value & 0xFF000000) >> 24)};
        return b;
    }

    private static byte[] writeShort(short value) throws IOException {
        byte[] b = new byte[]{(byte)(value & 0xFF), (byte)((value & 0xFF00) >> 8)};
        return b;
    }
}

