/*
 * Decompiled with CFR 0.152.
 */
package com.kelin.okpermission.applicant.intentgenerator;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import com.kelin.okpermission.applicant.intentgenerator.SettingIntentGenerator;
import com.kelin.okpermission.permission.Permission;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\f"}, d2={"Lcom/kelin/okpermission/applicant/intentgenerator/MIUISettingsIntentGenerator;", "Lcom/kelin/okpermission/applicant/intentgenerator/SettingIntentGenerator;", "permission", "Lcom/kelin/okpermission/permission/Permission;", "(Lcom/kelin/okpermission/permission/Permission;)V", "getMIUIVersion", "", "onGeneratorDangerousIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "onGeneratorSystemWindowIntent", "okpermission_release"})
public final class MIUISettingsIntentGenerator
extends SettingIntentGenerator {
    public MIUISettingsIntentGenerator(@Nullable Permission permission2) {
        super(permission2);
    }

    @Override
    @NotNull
    protected Intent onGeneratorDangerousIntent(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent intent = new Intent("miui.intent.action.APP_PERM_EDITOR");
        intent.putExtra("extra_pkgname", context.getPackageName());
        if (SettingIntentGenerator.Companion.checkIntentAvailable(context, intent)) {
            return intent;
        }
        intent.setPackage("com.miui.securitycenter");
        if (SettingIntentGenerator.Companion.checkIntentAvailable(context, intent)) {
            return intent;
        }
        intent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.AppPermissionsEditorActivity");
        if (SettingIntentGenerator.Companion.checkIntentAvailable(context, intent)) {
            return intent;
        }
        intent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.PermissionsEditorActivity");
        return intent;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Intent onGeneratorSystemWindowIntent(@NotNull Context context) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT < 23) {
            int version = this.getMIUIVersion();
            switch (version) {
                case 5: {
                    String packageName = context.getPackageName();
                    Intent intent2 = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                    Uri uri = Uri.fromParts((String)"package", (String)packageName, null);
                    intent2.setData(uri);
                    intent2.setFlags(0x10000000);
                    intent = intent2;
                    break;
                }
                case 6: {
                    Intent intent3 = new Intent("miui.intent.action.APP_PERM_EDITOR");
                    intent3.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.AppPermissionsEditorActivity");
                    intent3.putExtra("extra_pkgname", context.getPackageName());
                    intent3.setFlags(0x10000000);
                    intent = intent3;
                    break;
                }
                case 7: {
                    Intent intent4 = new Intent("miui.intent.action.APP_PERM_EDITOR");
                    intent4.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.AppPermissionsEditorActivity");
                    intent4.putExtra("extra_pkgname", context.getPackageName());
                    intent4.setFlags(0x10000000);
                    intent = intent4;
                    break;
                }
                case 8: {
                    void var3_6;
                    Intent intent5 = new Intent("miui.intent.action.APP_PERM_EDITOR");
                    intent5.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.PermissionsEditorActivity");
                    intent5.putExtra("extra_pkgname", context.getPackageName());
                    intent5.setFlags(0x10000000);
                    if (!SettingIntentGenerator.Companion.checkIntentAvailable(context, intent5)) {
                        intent5 = new Intent("miui.intent.action.APP_PERM_EDITOR");
                        intent5.setPackage("com.miui.securitycenter");
                        intent5.putExtra("extra_pkgname", context.getPackageName());
                        intent5.setFlags(0x10000000);
                    }
                    intent = var3_6;
                    break;
                }
                default: {
                    Log.e((String)"====", (String)("MIUISettingsIntentGenerator: this is a special MIUI rom version, its version code " + version));
                    intent = this.generatorAppDetailIntent(context);
                    break;
                }
            }
        } else {
            intent = super.onGeneratorSystemWindowIntent(context);
        }
        return intent;
    }

    private final int getMIUIVersion() {
        String version = this.getSystemProperty("ro.miui.ui.version.name");
        if (version != null) {
            try {
                String string = version.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return Integer.parseInt(string);
            }
            catch (Exception e) {
                Log.getStackTraceString((Throwable)e);
            }
        }
        return -1;
    }
}

