/*
 * Decompiled with CFR 0.152.
 */
package io.github.kdabir.adl.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class ActiveDirectoryConfig {
    public static final String SERVER_URL_KEY = "activedirectory.server.url";
    public static final String SERVER_DOMAIN_KEY = "activedirectory.server.domain";
    public static final String SEARCH_BASE_KEY = "activedirectory.search.base";
    public static final String BIND_USERNAME_KEY = "activedirectory.bind.username";
    public static final String BIND_PASSWORD_KEY = "activedirectory.bind.password";
    public static final String LOOKUP_ATTRS_KEY = "activedirectory.lookup.attrs";
    public static final String DEFAULT_CONFIG_FILE_NAME = "adl.properties";
    public static final String EMPTY_STRING = "";
    final Properties config = new Properties();

    public ActiveDirectoryConfig() throws IOException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_CONFIG_FILE_NAME);
        if (stream != null) {
            this.config.load(stream);
            stream.close();
        } else {
            this.loadConfigFromFile("./adl.properties");
        }
    }

    public ActiveDirectoryConfig(String filename) throws IOException {
        this.loadConfigFromFile(filename);
    }

    private void loadConfigFromFile(String filename) throws IOException {
        try (FileInputStream inStream = new FileInputStream(filename);){
            this.config.load(inStream);
        }
    }

    public ActiveDirectoryConfig(InputStream stream) throws IOException {
        this.config.load(stream);
    }

    public String getUsername() {
        return this.config.getProperty(BIND_USERNAME_KEY, EMPTY_STRING).trim();
    }

    public String getPassword() {
        return this.config.getProperty(BIND_PASSWORD_KEY, EMPTY_STRING).trim();
    }

    public String getUrl() {
        return this.config.getProperty(SERVER_URL_KEY, EMPTY_STRING).trim();
    }

    public String getDomain() {
        return this.config.getProperty(SERVER_DOMAIN_KEY, EMPTY_STRING).trim();
    }

    public String getSearchBase() {
        return this.config.getProperty(SEARCH_BASE_KEY, EMPTY_STRING).trim();
    }

    public List<String> getLookupAttrs() {
        return Arrays.asList(this.config.getProperty(LOOKUP_ATTRS_KEY, EMPTY_STRING).split(",( )*"));
    }

    public String toString() {
        return this.config.toString();
    }

    public static boolean hasValue(String string) {
        return string != null && string.trim().length() > 0;
    }
}

