/*
 * Decompiled with CFR 0.152.
 */
package io.github.kdabir.adl.api;

import io.github.kdabir.adl.api.filters.SearchFilter;
import io.github.kdabir.adl.api.mapper.SearchResultMapper;
import io.github.kdabir.adl.exceptions.ActiveDirectoryException;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapContext;

public class ActiveDirectorySearcher<T> {
    protected LdapContext ldapContext = null;
    protected String searchBase = null;
    protected List<String> returnedAttrs = null;
    protected SearchResultMapper<T> searchResultMapper = null;

    public ActiveDirectorySearcher(LdapContext ldapContext, String searchBase, SearchResultMapper<T> searchResultMapper) {
        this.ldapContext = ldapContext;
        this.searchBase = searchBase;
        this.searchResultMapper = searchResultMapper;
    }

    public List<T> search(SearchFilter searchFilter) {
        try {
            return this.searchResultMapper.mapResult(this.ldapContext.search(this.searchBase, searchFilter.getFilter(), this.getSearchControls()));
        }
        catch (NamingException ex) {
            throw new ActiveDirectoryException("Exception while searching Active Directory", ex);
        }
    }

    private SearchControls getSearchControls() {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        if (this.returnedAttrs != null && this.returnedAttrs.size() > 0) {
            searchControls.setReturningAttributes(this.returnedAttrs.toArray(new String[0]));
        }
        return searchControls;
    }

    public void close() {
        if (this.ldapContext != null) {
            try {
                this.ldapContext.close();
            }
            catch (NamingException ex) {
                throw new ActiveDirectoryException("Exception while closing the context", ex);
            }
        }
    }

    public ActiveDirectorySearcher<T> withReturnedAttrs(List<String> returnedAttrs) {
        this.returnedAttrs = returnedAttrs;
        return this;
    }

    public SearchResultMapper getSearchResultMapper() {
        return this.searchResultMapper;
    }

    public List<String> getReturnedAttrs() {
        return this.returnedAttrs;
    }
}

