/*
 * Decompiled with CFR 0.152.
 */
package io.github.kdabir.adl.api;

import io.github.kdabir.adl.api.LdapContextFactory;
import io.github.kdabir.adl.exceptions.ActiveDirectoryException;
import io.github.kdabir.adl.exceptions.BadCredentialsException;
import io.github.kdabir.adl.util.ActiveDirectoryEnvironmentProvider;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;

public class ActiveDirectoryBinder {
    private final ActiveDirectoryEnvironmentProvider activeDirectoryEnvironmentProvider;
    private final LdapContextFactory ldapContextFactory;

    public ActiveDirectoryBinder(ActiveDirectoryEnvironmentProvider activeDirectoryEnvironmentProvider, LdapContextFactory ldapContextFactory) {
        this.activeDirectoryEnvironmentProvider = activeDirectoryEnvironmentProvider;
        this.ldapContextFactory = ldapContextFactory;
    }

    public LdapContext getLdapContext(String url, String domain, String username, String password) {
        Hashtable<String, String> environment = this.activeDirectoryEnvironmentProvider.getActiveDirectoryEnvironment(url, domain, username, password);
        try {
            return this.ldapContextFactory.getLdapContext(environment);
        }
        catch (AuthenticationException ex) {
            throw new BadCredentialsException(ex);
        }
        catch (CommunicationException ex) {
            throw new ActiveDirectoryException(ex);
        }
        catch (NamingException ex) {
            throw new ActiveDirectoryException(ex);
        }
    }
}

