/*
 * Decompiled with CFR 0.152.
 */
package io.github.kdabir.adl.api;

import io.github.kdabir.adl.api.ActiveDirectoryBinder;
import io.github.kdabir.adl.api.LdapContextFactory;
import io.github.kdabir.adl.api.SimpleActiveDirectorySearcher;
import io.github.kdabir.adl.api.filters.UsernameFilter;
import io.github.kdabir.adl.exceptions.BadCredentialsException;
import io.github.kdabir.adl.exceptions.NotFoundException;
import io.github.kdabir.adl.util.ActiveDirectoryEnvironmentProvider;
import io.github.kdabir.adl.util.SearchBaseGuesser;
import java.util.List;
import java.util.Map;
import javax.naming.ldap.LdapContext;

public class ActiveDirectoryAuthenticator {
    private String domain;
    private String url;
    private String searchBase;
    private List<String> returnedAttrs = null;

    public ActiveDirectoryAuthenticator(String domain, String url) {
        this(domain, url, new SearchBaseGuesser().guessFrom(domain), null);
    }

    public ActiveDirectoryAuthenticator(String domain, String url, String searchBase) {
        this(domain, url, searchBase, null);
    }

    public ActiveDirectoryAuthenticator(String domain, String url, String searchBase, List<String> returnedAttrs) {
        this.domain = domain;
        this.url = url;
        this.searchBase = searchBase;
        this.returnedAttrs = returnedAttrs;
    }

    public static ActiveDirectoryBinder getDefaultActiveDirectoryBinder() {
        return new ActiveDirectoryBinder(new ActiveDirectoryEnvironmentProvider(), new LdapContextFactory());
    }

    public Map<String, String> authenticate(String username, String password) throws BadCredentialsException, NotFoundException {
        LdapContext ldapContext = ActiveDirectoryAuthenticator.getDefaultActiveDirectoryBinder().getLdapContext(this.url, this.domain, username, password);
        List result = new SimpleActiveDirectorySearcher(ldapContext, this.searchBase).withReturnedAttrs(this.returnedAttrs).search(new UsernameFilter(username));
        if (result.size() < 1) {
            throw new NotFoundException("Username password matched, but user details could not be found in the given search base. Either search base is incorrect or user does not have privileges to search");
        }
        return (Map)result.get(0);
    }

    public boolean isValid(String username, String password) {
        try {
            ActiveDirectoryAuthenticator.getDefaultActiveDirectoryBinder().getLdapContext(this.url, this.domain, username, password);
            return true;
        }
        catch (BadCredentialsException ex) {
            return false;
        }
    }
}

