/*
 * Decompiled with CFR 0.152.
 */
package io.github.kattlo.cloudevents;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.message.Encoding;
import io.cloudevents.kafka.CloudEventSerializer;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy;
import io.github.kattlo.cloudevents.AvroCloudEventData;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaAvroCloudEventSerializer
extends KafkaAvroSerializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaAvroCloudEventSerializer.class);
    public static final String DATASCHEMA_HEADER = "ce_dataschema";
    private final CloudEventSerializer ce = new CloudEventSerializer();
    private String schemaRegistryUrl;

    public KafkaAvroCloudEventSerializer() {
    }

    public KafkaAvroCloudEventSerializer(SchemaRegistryClient client) {
        super(client);
    }

    private Encoding encodingOf(Map<String, ?> configs) {
        log.debug("serializer configurations {}", configs);
        Object encodingConfig = configs.get("cloudevents.serializer.encoding");
        Encoding encoding = null;
        if (encodingConfig instanceof String) {
            encoding = Encoding.valueOf((String)((String)encodingConfig));
        } else if (encodingConfig instanceof Encoding) {
            encoding = (Encoding)encodingConfig;
        } else if (encodingConfig != null) {
            throw new IllegalArgumentException("cloudevents.serializer.encoding can be of type String or " + Encoding.class.getCanonicalName());
        }
        return encoding;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        Encoding encoding = this.encodingOf(configs);
        if (encoding != Encoding.BINARY) {
            throw new IllegalArgumentException("cloudevents.serializer.encoding=" + encoding + " not supported");
        }
        super.configure(configs, isKey);
        this.ce.configure(configs, isKey);
        this.schemaRegistryUrl = (String)configs.get("schema.registry.url");
        log.debug("{}={}", (Object)"schema.registry.url", (Object)this.schemaRegistryUrl);
    }

    public byte[] serialize(String topic, Headers headers, Object event) {
        if (!(event instanceof CloudEvent)) {
            throw new IllegalArgumentException("event argument must be an instance of " + CloudEvent.class);
        }
        CloudEvent ceEvent = (CloudEvent)event;
        this.ce.serialize(topic, headers, ceEvent);
        log.debug("CloudEvent headers {}", (Object)headers);
        if (ceEvent.getData() instanceof AvroCloudEventData) {
            AvroCloudEventData data = (AvroCloudEventData)ceEvent.getData();
            Object value = data.getValue();
            Class<?> valueType = value.getClass();
            log.debug("value to serialize as avro {}", value);
            byte[] bytes = super.serialize(topic, headers, data.getValue());
            SubjectNameStrategy strategy = (SubjectNameStrategy)this.valueSubjectNameStrategy;
            log.debug("SubjectNameStrategy {}", (Object)strategy);
            String subjectName = strategy.subjectName(topic, Boolean.FALSE.booleanValue(), (ParsedSchema)new NoSchema(valueType.getPackageName(), valueType.getSimpleName()));
            log.info("SubjectName {}", (Object)subjectName);
            try {
                List versions = this.schemaRegistry.getAllVersions(subjectName);
                Integer version = (Integer)versions.get(versions.size() - 1);
                log.debug("Schema versionId {}", (Object)version);
                String dataschema = this.schemaRegistryUrl + "/subjects/" + subjectName + "/versions/" + version + "/schema";
                log.debug("{}={}", (Object)DATASCHEMA_HEADER, (Object)dataschema);
                headers.remove(DATASCHEMA_HEADER);
                headers.add(DATASCHEMA_HEADER, dataschema.getBytes());
            }
            catch (RestClientException | IOException e) {
                throw new SerializationException(e.getMessage(), e);
            }
            return bytes;
        }
        throw new IllegalArgumentException("CloudEvent data attribute must be an instance of " + AvroCloudEventData.class.getName());
    }

    private static final class NoSchema
    implements ParsedSchema {
        private final String namespace;
        private final String name;

        public NoSchema(String namespace, String name) {
            this.namespace = Objects.requireNonNull(namespace);
            this.name = Objects.requireNonNull(name);
        }

        public String canonicalString() {
            throw new UnsupportedOperationException();
        }

        public boolean isBackwardCompatible(ParsedSchema arg0) {
            throw new UnsupportedOperationException();
        }

        public String name() {
            return this.namespace + "." + this.name;
        }

        public Object rawSchema() {
            throw new UnsupportedOperationException();
        }

        public List<SchemaReference> references() {
            throw new UnsupportedOperationException();
        }

        public String schemaType() {
            throw new UnsupportedOperationException();
        }
    }
}

