/*
 * Decompiled with CFR 0.152.
 */
package io.github.kattlo.cloudevents;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.kafka.CloudEventDeserializer;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.github.kattlo.cloudevents.AvroCloudEventData;
import java.util.Map;
import lombok.Generated;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.common.header.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaAvroCloudEventDeserializer
extends KafkaAvroDeserializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaAvroCloudEventDeserializer.class);
    private CloudEventDeserializer ce = new CloudEventDeserializer();

    public KafkaAvroCloudEventDeserializer() {
    }

    public KafkaAvroCloudEventDeserializer(SchemaRegistryClient registry) {
        super(registry);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        log.debug("deserializer configurations {}", configs);
        super.configure(configs, isKey);
        this.ce.configure(configs, isKey);
    }

    public CloudEvent deserialize(String topic, Headers headers, byte[] bytes) {
        Object value = super.deserialize(topic, headers, bytes);
        AvroCloudEventData<GenericRecord> data = new AvroCloudEventData<GenericRecord>((GenericRecord)value);
        CloudEvent event = this.ce.deserialize(topic, headers, bytes);
        CloudEvent result = CloudEventBuilder.from((CloudEvent)event).withData("application/avro", data).build();
        return result;
    }
}

