/*
 * Decompiled with CFR 0.152.
 */
package com.github.karthyks.runtimepermissions.prefs;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;

public class SharedPrefUtil {
    public static final String PREF_FILE_NAME = "runtime_permission_checker";
    public static final String LOCATION = "location";
    public static final String CONTACTS = "contacts";
    public static final String CALENDAR = "calendar";
    public static final String CAMERA = "camera";
    public static final String MICROPHONE = "microphone";
    public static final String PHONE = "phone";
    public static final String SENSORS = "sensors";
    public static final String SMS = "sms";
    public static final String STORAGE = "storage";

    public static void putInSharedPref(Context context, int permissionCode, boolean isDenied) {
        SharedPreferences.Editor sharedPref = context.getSharedPreferences(PREF_FILE_NAME, 0).edit();
        switch (permissionCode) {
            case 201: {
                sharedPref.putBoolean(CONTACTS, isDenied);
                break;
            }
            case 203: {
                sharedPref.putBoolean(CALENDAR, isDenied);
                break;
            }
            case 200: {
                sharedPref.putBoolean(CAMERA, isDenied);
                break;
            }
            case 202: {
                sharedPref.putBoolean(LOCATION, isDenied);
                break;
            }
            case 204: {
                sharedPref.putBoolean(MICROPHONE, isDenied);
                break;
            }
            case 206: {
                sharedPref.putBoolean(PHONE, isDenied);
                break;
            }
            case 207: {
                sharedPref.putBoolean(SENSORS, isDenied);
                break;
            }
            case 205: {
                sharedPref.putBoolean(SMS, isDenied);
                break;
            }
            case 208: {
                sharedPref.putBoolean(STORAGE, isDenied);
                break;
            }
        }
        boolean result = sharedPref.commit();
        Log.d((String)"SharedPref", (String)("putInSharedPref:Commit " + result));
    }

    public static boolean isDeniedOnce(Context context, int permissionCode) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_FILE_NAME, 0);
        switch (permissionCode) {
            case 201: {
                return sharedPreferences.getBoolean(CONTACTS, false);
            }
            case 203: {
                return sharedPreferences.getBoolean(CALENDAR, false);
            }
            case 200: {
                return sharedPreferences.getBoolean(CAMERA, false);
            }
            case 202: {
                return sharedPreferences.getBoolean(LOCATION, false);
            }
            case 204: {
                return sharedPreferences.getBoolean(MICROPHONE, false);
            }
            case 206: {
                return sharedPreferences.getBoolean(PHONE, false);
            }
            case 207: {
                return sharedPreferences.getBoolean(SENSORS, false);
            }
            case 205: {
                return sharedPreferences.getBoolean(SMS, false);
            }
            case 208: {
                return sharedPreferences.getBoolean(STORAGE, false);
            }
        }
        return false;
    }
}

