/*
 * Decompiled with CFR 0.152.
 */
package com.karan.churi.PermissionManager;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class PermissionManager {
    private Activity activity;

    public boolean checkAndRequestPermissions(Activity activity) {
        this.activity = activity;
        if (Build.VERSION.SDK_INT >= 23) {
            List<String> listPermissionsNeeded = this.setPermission();
            ArrayList<String> listPermissionsAssign = new ArrayList<String>();
            for (String per : listPermissionsNeeded) {
                if (ContextCompat.checkSelfPermission((Context)activity.getApplicationContext(), (String)per) == 0) continue;
                listPermissionsAssign.add(per);
            }
            if (!listPermissionsAssign.isEmpty()) {
                ActivityCompat.requestPermissions((Activity)activity, (String[])listPermissionsAssign.toArray(new String[listPermissionsAssign.size()]), (int)1212);
                return false;
            }
        }
        return true;
    }

    public ArrayList<statusArray> getStatus() {
        ArrayList<statusArray> statusPermission = new ArrayList<statusArray>();
        ArrayList<String> grant = new ArrayList<String>();
        ArrayList<String> deny = new ArrayList<String>();
        List<String> listPermissionsNeeded = this.setPermission();
        for (String per : listPermissionsNeeded) {
            if (ContextCompat.checkSelfPermission((Context)this.activity.getApplicationContext(), (String)per) == 0) {
                grant.add(per);
                continue;
            }
            deny.add(per);
        }
        statusArray stat = new statusArray(grant, deny);
        statusPermission.add(stat);
        return statusPermission;
    }

    public List<String> setPermission() {
        ArrayList<String> per = new ArrayList<String>();
        try {
            String[] permissionInfo;
            PackageManager pm = this.activity.getApplicationContext().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(this.activity.getApplicationContext().getPackageName(), 4096);
            for (String p : permissionInfo = pi.requestedPermissions) {
                per.add(p);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return per;
    }

    public void checkResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 1212: {
                boolean bl;
                List<String> listPermissionsNeeded = this.setPermission();
                HashMap<String, Integer> perms = new HashMap<String, Integer>();
                for (String string : listPermissionsNeeded) {
                    perms.put(string, 0);
                }
                if (grantResults.length <= 0) break;
                for (int i = 0; i < permissions.length; ++i) {
                    perms.put(permissions[i], grantResults[i]);
                }
                boolean isAllGranted = true;
                for (String permission : listPermissionsNeeded) {
                    if ((Integer)perms.get(permission) != -1) continue;
                    isAllGranted = false;
                    break;
                }
                if (isAllGranted) break;
                boolean bl2 = false;
                for (String permission : listPermissionsNeeded) {
                    if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.activity, (String)permission)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.ifCancelledAndCanRequest(this.activity);
                    break;
                }
                this.ifCancelledAndCannotRequest(this.activity);
            }
        }
    }

    public void ifCancelledAndCanRequest(final Activity activity) {
        this.showDialogOK(activity, "Some Permission required for this app, please grant permission for the same", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                switch (which) {
                    case -1: {
                        PermissionManager.this.checkAndRequestPermissions(activity);
                        break;
                    }
                }
            }
        });
    }

    public void ifCancelledAndCannotRequest(Activity activity) {
        Toast.makeText((Context)activity.getApplicationContext(), (CharSequence)"Go to settings and enable permissions", (int)1).show();
    }

    private void showDialogOK(Activity activity, String message, DialogInterface.OnClickListener okListener) {
        new AlertDialog.Builder((Context)activity).setMessage((CharSequence)message).setPositiveButton((CharSequence)"OK", okListener).setNegativeButton((CharSequence)"Cancel", okListener).create().show();
    }

    public class statusArray {
        public ArrayList<String> granted;
        public ArrayList<String> denied;

        statusArray(ArrayList<String> granted, ArrayList<String> denied) {
            this.denied = denied;
            this.granted = granted;
        }
    }
}

