/*
 * Decompiled with CFR 0.152.
 */
package com.kapil.circularlayoutmanager;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.Px;
import androidx.core.content.ContextCompat;
import com.kapil.circularlayoutmanager.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ(\u0010:\u001a\u00020\r2\u0006\u0010;\u001a\u00020\r2\u0006\u0010<\u001a\u00020\r2\u0006\u0010=\u001a\u00020\r2\u0006\u0010>\u001a\u00020\rH\u0002J\b\u0010?\u001a\u00020\bH\u0007J\u0010\u0010@\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020\u00182\u0006\u0010D\u001a\u00020EH\u0014J(\u0010F\u001a\u00020\u000f2\u0006\u0010G\u001a\u00020B2\u0006\u0010H\u001a\u00020B2\u0006\u0010I\u001a\u00020\r2\u0006\u0010J\u001a\u00020\rH\u0016J\u0010\u0010K\u001a\u00020\u00182\u0006\u0010A\u001a\u00020BH\u0016J\u0018\u0010L\u001a\u00020\u00182\u0006\u0010M\u001a\u00020\b2\u0006\u0010N\u001a\u00020\bH\u0014J(\u0010O\u001a\u00020\u000f2\u0006\u0010G\u001a\u00020B2\u0006\u0010H\u001a\u00020B2\u0006\u0010P\u001a\u00020\r2\u0006\u0010Q\u001a\u00020\rH\u0016J\u0010\u0010R\u001a\u00020\u00182\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010S\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010T\u001a\u00020\u000f2\u0006\u0010U\u001a\u00020BH\u0017J\u0010\u0010V\u001a\u00020\u00182\b\b\u0001\u0010W\u001a\u00020\bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R(\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR.\u0010\u001d\u001a\u0016\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R.\u0010#\u001a\u0016\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"R(\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001a\"\u0004\b(\u0010\u001cR\"\u0010)\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u000e\u0010/\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u00102\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u000e\u00107\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lcom/kapil/circularlayoutmanager/ScrollWheel;", "Landroid/view/View;", "Landroid/view/GestureDetector$OnGestureListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "gestureDetector", "Landroid/view/GestureDetector;", "innerRadius", "", "isHandleClicksEnabled", "", "()Z", "setHandleClicksEnabled", "(Z)V", "value", "isHighlightTouchAreaEnabled", "setHighlightTouchAreaEnabled", "onFlingListener", "Lkotlin/Function1;", "", "getOnFlingListener", "()Lkotlin/jvm/functions/Function1;", "setOnFlingListener", "(Lkotlin/jvm/functions/Function1;)V", "onItemClickListener", "Lkotlin/Function2;", "getOnItemClickListener", "()Lkotlin/jvm/functions/Function2;", "setOnItemClickListener", "(Lkotlin/jvm/functions/Function2;)V", "onItemLongClickListener", "getOnItemLongClickListener", "setOnItemLongClickListener", "onScrollListener", "getOnScrollListener", "setOnScrollListener", "onTouchReleasedListener", "Lkotlin/Function0;", "getOnTouchReleasedListener", "()Lkotlin/jvm/functions/Function0;", "setOnTouchReleasedListener", "(Lkotlin/jvm/functions/Function0;)V", "outerRadius", "touchAreaPaint", "Landroid/graphics/Paint;", "touchAreaThickness", "getTouchAreaThickness", "()F", "setTouchAreaThickness", "(F)V", "touchInitiatedBetweenCircles", "xCenter", "yCenter", "calculateDelta", "x", "y", "dx", "dy", "getTouchAreaColor", "onDown", "e", "Landroid/view/MotionEvent;", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onFling", "e1", "e2", "velocityX", "velocityY", "onLongPress", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onScroll", "distanceX", "distanceY", "onShowPress", "onSingleTapUp", "onTouchEvent", "event", "setTouchAreaColor", "touchAreaColor", "circular-layout-manager_release"})
public final class ScrollWheel
extends View
implements GestureDetector.OnGestureListener {
    private boolean isHighlightTouchAreaEnabled;
    private boolean isHandleClicksEnabled;
    @Px
    private float touchAreaThickness;
    @Nullable
    private Function2<? super Float, ? super Float, Unit> onItemClickListener;
    @Nullable
    private Function2<? super Float, ? super Float, Unit> onItemLongClickListener;
    @Nullable
    private Function1<? super Float, Unit> onScrollListener;
    @Nullable
    private Function1<? super Float, Unit> onFlingListener;
    @Nullable
    private Function0<Unit> onTouchReleasedListener;
    private float xCenter;
    private float yCenter;
    private float innerRadius;
    private float outerRadius;
    private boolean touchInitiatedBetweenCircles;
    private Paint touchAreaPaint;
    private GestureDetector gestureDetector;
    private HashMap _$_findViewCache;

    public final boolean isHighlightTouchAreaEnabled() {
        return this.isHighlightTouchAreaEnabled;
    }

    public final void setHighlightTouchAreaEnabled(boolean value) {
        this.isHighlightTouchAreaEnabled = value;
        this.invalidate();
    }

    public final boolean isHandleClicksEnabled() {
        return this.isHandleClicksEnabled;
    }

    public final void setHandleClicksEnabled(boolean bl) {
        this.isHandleClicksEnabled = bl;
    }

    public final float getTouchAreaThickness() {
        return this.touchAreaThickness;
    }

    public final void setTouchAreaThickness(float value) {
        this.touchAreaThickness = value;
        this.invalidate();
    }

    @Nullable
    public final Function2<Float, Float, Unit> getOnItemClickListener() {
        return this.onItemClickListener;
    }

    public final void setOnItemClickListener(@Nullable Function2<? super Float, ? super Float, Unit> function2) {
        this.onItemClickListener = function2;
    }

    @Nullable
    public final Function2<Float, Float, Unit> getOnItemLongClickListener() {
        return this.onItemLongClickListener;
    }

    public final void setOnItemLongClickListener(@Nullable Function2<? super Float, ? super Float, Unit> function2) {
        this.onItemLongClickListener = function2;
    }

    @Nullable
    public final Function1<Float, Unit> getOnScrollListener() {
        return this.onScrollListener;
    }

    public final void setOnScrollListener(@Nullable Function1<? super Float, Unit> function1) {
        this.onScrollListener = function1;
    }

    @Nullable
    public final Function1<Float, Unit> getOnFlingListener() {
        return this.onFlingListener;
    }

    public final void setOnFlingListener(@Nullable Function1<? super Float, Unit> function1) {
        this.onFlingListener = function1;
    }

    @Nullable
    public final Function0<Unit> getOnTouchReleasedListener() {
        return this.onTouchReleasedListener;
    }

    public final void setOnTouchReleasedListener(@Nullable Function0<Unit> function0) {
        this.onTouchReleasedListener = function0;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.xCenter = (float)this.getMeasuredWidth() / 2.0f;
        this.yCenter = (float)this.getMeasuredHeight() / 2.0f;
        int n = this.getMeasuredWidth();
        int n2 = this.getMeasuredHeight();
        ScrollWheel scrollWheel = this;
        boolean bl = false;
        int n3 = Math.min(n, n2);
        scrollWheel.outerRadius = (float)n3 / 2.0f;
        this.innerRadius = this.outerRadius - this.touchAreaThickness;
        this.touchAreaPaint.setStrokeWidth(this.outerRadius - this.innerRadius);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (this.isHighlightTouchAreaEnabled) {
            canvas.drawCircle(this.xCenter, this.yCenter, (this.innerRadius + this.outerRadius) / 2.0f, this.touchAreaPaint);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            if (!this.isEnabled()) {
                return super.onTouchEvent(event);
            }
            if (event.getActionMasked() != 1) break block2;
            Function0<Unit> function0 = this.onTouchReleasedListener;
            if (function0 != null) {
                Unit cfr_ignored_0 = (Unit)function0.invoke();
            }
        }
        return this.gestureDetector.onTouchEvent(event);
    }

    public boolean onDown(@NotNull MotionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        float x = e.getX();
        float y = e.getY();
        this.touchInitiatedBetweenCircles = (x - this.xCenter) * (x - this.xCenter) + (y - this.yCenter) * (y - this.yCenter) > this.innerRadius * this.innerRadius && (x - this.xCenter) * (x - this.xCenter) + (y - this.yCenter) * (y - this.yCenter) < this.outerRadius * this.outerRadius;
        return this.isHandleClicksEnabled || this.touchInitiatedBetweenCircles;
    }

    public boolean onScroll(@NotNull MotionEvent e1, @NotNull MotionEvent e2, float distanceX, float distanceY) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)e1, (String)"e1");
            Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e2");
            if (!this.touchInitiatedBetweenCircles) break block1;
            Function1<? super Float, Unit> function1 = this.onScrollListener;
            if (function1 != null) {
                Unit cfr_ignored_0 = (Unit)function1.invoke((Object)Float.valueOf(this.calculateDelta(e2.getX(), e2.getY(), distanceX, distanceY)));
            }
        }
        return this.touchInitiatedBetweenCircles;
    }

    public boolean onFling(@NotNull MotionEvent e1, @NotNull MotionEvent e2, float velocityX, float velocityY) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)e1, (String)"e1");
            Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e2");
            if (!this.touchInitiatedBetweenCircles) break block1;
            Function1<? super Float, Unit> function1 = this.onFlingListener;
            if (function1 != null) {
                Unit cfr_ignored_0 = (Unit)function1.invoke((Object)Float.valueOf(-this.calculateDelta(e2.getX(), e2.getY(), velocityX, velocityY)));
            }
        }
        return this.touchInitiatedBetweenCircles;
    }

    public boolean onSingleTapUp(@NotNull MotionEvent e) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            if (!this.isHandleClicksEnabled) break block1;
            Function2<? super Float, ? super Float, Unit> function2 = this.onItemClickListener;
            if (function2 != null) {
                Unit cfr_ignored_0 = (Unit)function2.invoke((Object)Float.valueOf(e.getX()), (Object)Float.valueOf(e.getY()));
            }
        }
        return this.isHandleClicksEnabled;
    }

    public void onLongPress(@NotNull MotionEvent e) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            if (!this.isHandleClicksEnabled) break block1;
            Function2<? super Float, ? super Float, Unit> function2 = this.onItemLongClickListener;
            if (function2 != null) {
                Unit cfr_ignored_0 = (Unit)function2.invoke((Object)Float.valueOf(e.getX()), (Object)Float.valueOf(e.getY()));
            }
        }
    }

    public void onShowPress(@NotNull MotionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
    }

    private final float calculateDelta(float x, float y, float dx, float dy) {
        return x <= this.xCenter && y < this.yCenter ? dx - dy : (x > this.xCenter && y <= this.yCenter ? dx + dy : (x >= this.xCenter && y > this.yCenter ? -dx + dy : (x < this.xCenter && y >= this.yCenter ? -dx - dy : 0.0f)));
    }

    @ColorInt
    public final int getTouchAreaColor() {
        return this.touchAreaPaint.getColor();
    }

    public final void setTouchAreaColor(@ColorInt int touchAreaColor) {
        this.touchAreaPaint.setColor(touchAreaColor);
        this.invalidate();
    }

    @JvmOverloads
    public ScrollWheel(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.isHighlightTouchAreaEnabled = true;
        this.isHandleClicksEnabled = true;
        this.touchAreaThickness = context.getResources().getDimension(R.dimen.default_touch_area_thickness);
        Paint paint2 = new Paint();
        ScrollWheel scrollWheel = this;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply = paint2;
        boolean bl3 = false;
        $this$apply.setAntiAlias(true);
        $this$apply.setStyle(Paint.Style.STROKE);
        $this$apply.setColor(ContextCompat.getColor((Context)context, (int)R.color.default_touch_area_color));
        scrollWheel.touchAreaPaint = paint = paint2;
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
        paint2 = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ScrollWheel, 0, 0);
        bl = false;
        bl2 = false;
        $this$apply = paint2;
        boolean bl4 = false;
        this.isHandleClicksEnabled = $this$apply.getBoolean(R.styleable.ScrollWheel_isHandleClicksEnabled, true);
        this.setHighlightTouchAreaEnabled($this$apply.getBoolean(R.styleable.ScrollWheel_isHighlightTouchAreaEnabled, true));
        this.setTouchAreaThickness($this$apply.getDimension(R.styleable.ScrollWheel_touchAreaThickness, context.getResources().getDimension(R.dimen.default_touch_area_thickness)));
        this.setTouchAreaColor($this$apply.getColor(R.styleable.ScrollWheel_touchAreaColor, ContextCompat.getColor((Context)context, (int)R.color.default_touch_area_color)));
        $this$apply.recycle();
    }

    public /* synthetic */ ScrollWheel(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public ScrollWheel(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ScrollWheel(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

