/*
 * Decompiled with CFR 0.152.
 */
package com.kapil.circularlayoutmanager;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.util.AttributeSet;
import android.widget.RelativeLayout;
import com.kapil.circularlayoutmanager.CircularRelativeLayout;

public class CircularRelativeLayout
extends RelativeLayout {
    private static final int WIDTH = 0;
    private static final int HEIGHT = 1;
    private static final int NONE = 2;
    private Path ovalPath;
    @Dimension
    private int primaryDimension;

    public CircularRelativeLayout(Context context) {
        super(context);
        this.init();
    }

    public CircularRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CircularRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setWillNotDraw(false);
        this.primaryDimension = 0;
        this.ovalPath = new Path();
    }

    @TargetApi(value=21)
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        switch (this.primaryDimension) {
            case 0: {
                this.getLayoutParams().height = this.getMeasuredWidth();
                break;
            }
            case 1: {
                this.getLayoutParams().width = this.getMeasuredHeight();
                break;
            }
        }
        this.ovalPath.reset();
        this.ovalPath.addOval(0.0f, 0.0f, (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight(), Path.Direction.CW);
        this.ovalPath.close();
    }

    protected void onDraw(Canvas canvas) {
        canvas.clipPath(this.ovalPath);
        super.onDraw(canvas);
    }

    public int getPrimaryDimension() {
        return this.primaryDimension;
    }

    public void setPrimaryDimension(@Dimension int primaryDimension) {
        this.primaryDimension = primaryDimension;
    }
}

