/*
 * Decompiled with CFR 0.152.
 */
package com.kapil.circularlayoutmanager;

import android.content.Context;
import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.kapil.circularlayoutmanager.CircularLayoutManager;
import com.kapil.circularlayoutmanager.Utils;
import java.util.List;

public class CircularLayoutManager
extends RecyclerView.LayoutManager {
    private static final int CIRCLE = 0;
    private static final int ELLIPSE = 1;
    private RecyclerView recyclerView;
    private Rect recyclerBounds;
    private int topOfFirstChild;
    private Rect childDecoratedBoundsWithMargin;
    private int verticalCenter;
    private boolean scrolled;
    private float radius;
    private float majorRadius;
    private float minorRadius;
    private float centerX;
    @LayoutPath
    private int layoutPath;

    public CircularLayoutManager(Context context, int radius, int centerX) {
        this.radius = Utils.dpToPx(context, radius);
        this.centerX = Utils.dpToPx(context, centerX);
        this.layoutPath = 0;
    }

    public CircularLayoutManager(Context context, int majorRadius, int minorRadius, int centerX) {
        this.majorRadius = Utils.dpToPx(context, majorRadius);
        this.minorRadius = Utils.dpToPx(context, minorRadius);
        this.centerX = Utils.dpToPx(context, centerX);
        this.layoutPath = 1;
    }

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-2, -2);
    }

    public void onAttachedToWindow(RecyclerView view) {
        super.onAttachedToWindow(view);
        this.recyclerView = view;
        this.topOfFirstChild = 0;
        this.childDecoratedBoundsWithMargin = new Rect();
        this.scrolled = false;
    }

    public void onDetachedFromWindow(RecyclerView view, RecyclerView.Recycler recycler) {
        super.onDetachedFromWindow(view, recycler);
        this.removeAndRecycleAllViews(recycler);
        recycler.clear();
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getItemCount() == 0) {
            this.detachAndScrapAttachedViews(recycler);
            return;
        }
        if (this.recyclerBounds == null) {
            this.recyclerBounds = new Rect();
            this.recyclerView.getHitRect(this.recyclerBounds);
            this.verticalCenter = this.recyclerBounds.height() / 2;
        }
        if (this.getChildCount() == 0) {
            this.fill(0, recycler);
        }
    }

    private void fill(int indexToStartFill, RecyclerView.Recycler recycler) {
        if (indexToStartFill < 0) {
            indexToStartFill = 0;
        }
        int childTop = this.topOfFirstChild;
        this.detachAndScrapAttachedViews(recycler);
        for (int i = indexToStartFill; i < this.getItemCount(); ++i) {
            View child = recycler.getViewForPosition(i);
            this.measureChildWithMargins(child, 0, 0);
            int sumOfHorizontalMargins = ((RecyclerView.LayoutParams)child.getLayoutParams()).leftMargin + ((RecyclerView.LayoutParams)child.getLayoutParams()).rightMargin;
            int sumOfVerticalMargins = ((RecyclerView.LayoutParams)child.getLayoutParams()).topMargin + ((RecyclerView.LayoutParams)child.getLayoutParams()).bottomMargin;
            int childLeft = 0;
            switch (this.layoutPath) {
                case 0: {
                    childLeft = this.calculateCircleXFromY(childTop + (this.getDecoratedMeasuredHeight(child) + this.getTopDecorationHeight(child) - this.getBottomDecorationHeight(child) + sumOfVerticalMargins) / 2);
                    break;
                }
                case 1: {
                    childLeft = this.calculateEllipseXFromY(childTop + (this.getDecoratedMeasuredHeight(child) + this.getTopDecorationHeight(child) - this.getBottomDecorationHeight(child) + sumOfVerticalMargins) / 2);
                }
            }
            if (!this.recyclerBounds.intersects(this.recyclerBounds.left + childLeft, this.recyclerBounds.top + childTop, this.recyclerBounds.left + childLeft + this.getDecoratedMeasuredWidth(child) + sumOfHorizontalMargins, this.recyclerBounds.top + childTop + this.getDecoratedMeasuredHeight(child) + sumOfVerticalMargins) && !this.recyclerBounds.contains(this.recyclerBounds.left + childLeft, this.recyclerBounds.top + childTop, this.recyclerBounds.left + childLeft + this.getDecoratedMeasuredWidth(child) + sumOfHorizontalMargins, this.recyclerBounds.top + childTop + this.getDecoratedMeasuredHeight(child) + sumOfVerticalMargins)) break;
            this.addView(child);
            this.layoutDecoratedWithMargins(child, childLeft, childTop, childLeft + this.getDecoratedMeasuredWidth(child) + sumOfHorizontalMargins, childTop + this.getDecoratedMeasuredHeight(child) + sumOfVerticalMargins);
            this.getDecoratedBoundsWithMargins(child, this.childDecoratedBoundsWithMargin);
            this.scaleChild(child);
            childTop += this.childDecoratedBoundsWithMargin.height();
        }
        List scrapList = recycler.getScrapList();
        for (int i = 0; i < scrapList.size(); ++i) {
            View viewRemoved = ((RecyclerView.ViewHolder)scrapList.get((int)i)).itemView;
            recycler.recycleView(viewRemoved);
        }
        if (!this.scrolled) {
            this.stabilize();
        }
    }

    public boolean canScrollVertically() {
        return true;
    }

    public void onScrollStateChanged(int state) {
        if (state == 0) {
            this.stabilize();
        }
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        int delta;
        if (!this.scrolled) {
            this.scrolled = true;
        }
        if ((delta = dy) > 150) {
            delta = 150;
        }
        if (delta < -150) {
            delta = -150;
        }
        if (this.getChildCount() == 0) {
            return dy;
        }
        if (this.getPosition(this.getChildAt(this.getChildCount() - 1)) == this.getItemCount() - 1) {
            View child = this.getChildAt(this.getChildCount() - 1);
            this.getDecoratedBoundsWithMargins(child, this.childDecoratedBoundsWithMargin);
            if (this.childDecoratedBoundsWithMargin.bottom - delta < this.recyclerBounds.height()) {
                int position = this.recyclerBounds.height();
                int indexToStartFill = this.getPosition(this.getChildAt(0));
                for (int i = this.getChildCount() - 1; i >= 0; --i) {
                    this.getDecoratedBoundsWithMargins(this.getChildAt(i), this.childDecoratedBoundsWithMargin);
                    if ((position -= this.childDecoratedBoundsWithMargin.height()) > 0) continue;
                    this.topOfFirstChild = position;
                    if (this.topOfFirstChild <= -this.childDecoratedBoundsWithMargin.height()) {
                        this.topOfFirstChild += this.childDecoratedBoundsWithMargin.height();
                    }
                    if ((indexToStartFill = this.getPosition(this.getChildAt(i))) < this.getItemCount()) break;
                    indexToStartFill = this.getItemCount() - 1;
                    break;
                }
                this.fill(indexToStartFill, recycler);
                return 0;
            }
        }
        this.topOfFirstChild -= delta;
        this.getDecoratedBoundsWithMargins(this.getChildAt(0), this.childDecoratedBoundsWithMargin);
        int indexToStartFill = this.getPosition(this.getChildAt(0));
        if (this.topOfFirstChild > 0) {
            this.topOfFirstChild -= this.childDecoratedBoundsWithMargin.height();
            if (--indexToStartFill == -1) {
                this.topOfFirstChild = 0;
                this.fill(0, recycler);
                return 0;
            }
        } else if (this.topOfFirstChild <= -this.childDecoratedBoundsWithMargin.height()) {
            this.topOfFirstChild += this.childDecoratedBoundsWithMargin.height();
            ++indexToStartFill;
        }
        this.fill(indexToStartFill, recycler);
        return dy;
    }

    private void scaleChild(View child) {
        int y = (child.getTop() + child.getBottom()) / 2;
        float scale = 1.0f - (float)Math.abs(this.verticalCenter - y) / (float)(this.recyclerBounds.height() - child.getHeight());
        child.setPivotX(0.0f);
        child.setScaleX(scale);
        child.setScaleY(scale);
    }

    private int calculateCircleXFromY(int y) {
        int centerY = this.verticalCenter;
        return (int)(Math.sqrt(this.radius * this.radius - (float)((y - centerY) * (y - centerY))) + (double)this.centerX);
    }

    private int calculateEllipseXFromY(int y) {
        int centerY = this.verticalCenter;
        return (int)(Math.sqrt((1.0f - (float)((y - centerY) * (y - centerY)) / (this.minorRadius * this.minorRadius)) * (this.majorRadius * this.majorRadius)) + (double)this.centerX);
    }

    public void stabilize() {
        View child;
        int y;
        int minDistance = Integer.MAX_VALUE;
        for (int i = 0; i < this.getChildCount() && Math.abs((y = ((child = this.getChildAt(i)).getTop() + child.getBottom()) / 2) - this.verticalCenter) < Math.abs(minDistance); ++i) {
            minDistance = y - this.verticalCenter;
        }
        this.recyclerView.smoothScrollBy(0, minDistance);
    }
}

