package kalaganov.circular

import java.text.DecimalFormat
import java.text.DecimalFormatSymbols

/**
 * Created by Eugene on 15.05.2018
 */

internal object DefaultProgressFormatter : ProgressFormatter {

    private val decimalFormat: DecimalFormat by lazy {
        DecimalFormat("#.#").apply {
            decimalFormatSymbols = DecimalFormatSymbols().apply { decimalSeparator = '.' }
        }
    }

    override fun format(value: Float, minValue: Float, maxValue: Float): String = decimalFormat.format(value)
}