/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples.boot.config;

import com.github.kagkarlsson.examples.boot.ExampleContext;
import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.TaskDescriptor;
import com.github.kagkarlsson.scheduler.task.helper.CustomTask;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import com.github.kagkarlsson.scheduler.task.schedule.Schedules;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import utils.EventLogger;

@Configuration
public class LongRunningJobConfiguration {
    public static final TaskDescriptor<PrimeGeneratorState> LONG_RUNNING_TASK = TaskDescriptor.of((String)"long-running-task", PrimeGeneratorState.class);

    public static void start(ExampleContext ctx) {
        ctx.log("Scheduling long-running task " + LONG_RUNNING_TASK.getTaskName() + " to run 3s at a time until it has found all prime-numbers smaller than 1.000.000.");
        PrimeGeneratorState initialState = new PrimeGeneratorState(0L, 0L);
        ctx.schedulerClient.scheduleIfNotExists(LONG_RUNNING_TASK.instance("prime-generator").data((Object)initialState).scheduledTo(Instant.now()));
    }

    @Bean
    public CustomTask<PrimeGeneratorState> longRunningTask() {
        return Tasks.custom(LONG_RUNNING_TASK).execute((taskInstance, executionContext) -> {
            EventLogger.logTask(LONG_RUNNING_TASK, "Continuing prime-number generation from: " + String.valueOf(taskInstance.getData()));
            long currentNumber = ((PrimeGeneratorState)taskInstance.getData()).lastTestedNumber;
            long lastFoundPrime = ((PrimeGeneratorState)taskInstance.getData()).lastFoundPrime;
            long start = System.currentTimeMillis();
            while (!executionContext.getSchedulerState().isShuttingDown() && this.maxSecondsSince(start, 3L)) {
                if (this.isPrime(currentNumber)) {
                    lastFoundPrime = currentNumber;
                }
                ++currentNumber;
            }
            if (currentNumber > 1000000L) {
                return new CompletionHandler.OnCompleteRemove();
            }
            PrimeGeneratorState stateToSave = new PrimeGeneratorState(lastFoundPrime, currentNumber);
            EventLogger.logTask(LONG_RUNNING_TASK, "Ran for 3s. Saving state for next run. Current state: " + String.valueOf(stateToSave));
            return new CompletionHandler.OnCompleteReschedule((Schedule)Schedules.fixedDelay((Duration)Duration.ofSeconds(10L)), (Object)stateToSave);
        });
    }

    private boolean maxSecondsSince(long start, long seconds) {
        return System.currentTimeMillis() - start < seconds * 1000L;
    }

    private boolean isPrime(long currentNumber) {
        for (long i = 2L; i < currentNumber; ++i) {
            if (currentNumber % i != 0L) continue;
            return false;
        }
        return true;
    }

    public static class PrimeGeneratorState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final long lastFoundPrime;
        public final long lastTestedNumber;

        public PrimeGeneratorState() {
            this(0L, 0L);
        }

        public PrimeGeneratorState(long lastFoundPrime, long lastTestedNumber) {
            this.lastFoundPrime = lastFoundPrime;
            this.lastTestedNumber = lastTestedNumber;
        }

        public String toString() {
            return "PrimeGeneratorState{lastFoundPrime=" + this.lastFoundPrime + ", lastTestedNumber=" + this.lastTestedNumber + "}";
        }
    }
}

