/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples;

import com.github.kagkarlsson.examples.helpers.Example;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskDescriptor;
import com.github.kagkarlsson.scheduler.task.helper.RecurringTaskWithPersistentSchedule;
import com.github.kagkarlsson.scheduler.task.helper.ScheduleAndData;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import com.github.kagkarlsson.scheduler.task.schedule.Schedules;
import java.time.Duration;
import javax.sql.DataSource;

public class StatefulRecurringTaskWithPersistentScheduleMain
extends Example {
    public static final TaskDescriptor<ScheduleAndInteger> DYNAMIC_RECURRING_TASK = TaskDescriptor.of((String)"dynamic-recurring-task", ScheduleAndInteger.class);

    public static void main(String[] args) {
        new StatefulRecurringTaskWithPersistentScheduleMain().runWithDatasource();
    }

    @Override
    public void run(DataSource dataSource) {
        RecurringTaskWithPersistentSchedule task = Tasks.recurringWithPersistentSchedule(DYNAMIC_RECURRING_TASK).executeStateful((taskInstance, executionContext) -> {
            System.out.printf("Instance: '%s' ran using persistent schedule '%s' and data '%s'\n", taskInstance.getId(), ((ScheduleAndInteger)taskInstance.getData()).getSchedule(), ((ScheduleAndInteger)taskInstance.getData()).getData());
            return ((ScheduleAndInteger)taskInstance.getData()).returnIncremented();
        });
        Scheduler scheduler = Scheduler.create((DataSource)dataSource, (Task[])new Task[]{task}).pollingInterval(Duration.ofSeconds(1L)).registerShutdownHook().build();
        scheduler.start();
        this.sleep(2000);
        scheduler.schedule(DYNAMIC_RECURRING_TASK.instance("id1").data((Object)new ScheduleAndInteger((Schedule)Schedules.fixedDelay((Duration)Duration.ofSeconds(3L)), 1)).scheduledAccordingToData());
    }

    public static class ScheduleAndInteger
    implements ScheduleAndData {
        private final Schedule schedule;
        private final Integer data;

        public ScheduleAndInteger() {
            this(null, null);
        }

        public ScheduleAndInteger(Schedule schedule, Integer data) {
            this.schedule = schedule;
            this.data = data;
        }

        public Schedule getSchedule() {
            return this.schedule;
        }

        public Integer getData() {
            return this.data;
        }

        public ScheduleAndInteger returnIncremented() {
            return new ScheduleAndInteger(this.getSchedule(), this.getData() + 1);
        }
    }
}

