/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples.kotlin;

import com.github.kagkarlsson.scheduler.serializer.Serializer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J3\u0010\n\u001a\u0004\u0018\u0001H\u000b\"\n\b\u0000\u0010\u000b*\u0004\u0018\u00010\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/github/kagkarlsson/examples/kotlin/KotlinSerializer;", "Lcom/github/kagkarlsson/scheduler/serializer/Serializer;", "<init>", "()V", "charset", "Ljava/nio/charset/Charset;", "serialize", "", "data", "", "deserialize", "T", "clazz", "Ljava/lang/Class;", "serializedData", "(Ljava/lang/Class;[B)Ljava/lang/Object;", "features"})
public final class KotlinSerializer
implements Serializer {
    @NotNull
    private final Charset charset;

    public KotlinSerializer() {
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        this.charset = charset;
    }

    @NotNull
    public byte[] serialize(@Nullable Object data) {
        if (data == null) {
            return new byte[0];
        }
        KSerializer serializer2 = SerializersKt.serializer((Type)data.getClass());
        byte[] byArray = Json.Default.encodeToString((SerializationStrategy)serializer2, data).getBytes(this.charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    @Nullable
    public <T> T deserialize(@NotNull Class<T> clazz, @Nullable byte[] serializedData) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (serializedData == null || Intrinsics.areEqual(clazz, Void.class)) {
            return null;
        }
        if (Intrinsics.areEqual(clazz, Object.class)) {
            return (T)Json.Default.decodeFromString((DeserializationStrategy)JsonElement.Companion.serializer(), StringsKt.decodeToString((byte[])serializedData));
        }
        KSerializer kSerializer = SerializersKt.serializer((Type)clazz);
        Intrinsics.checkNotNull((Object)kSerializer, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of com.github.kagkarlsson.examples.kotlin.KotlinSerializer.deserialize>");
        KSerializer deserializer = kSerializer;
        return (T)Json.Default.decodeFromString((DeserializationStrategy)deserializer, new String(serializedData, this.charset));
    }
}

