/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples;

import com.github.kagkarlsson.examples.helpers.Example;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskDescriptor;
import com.github.kagkarlsson.scheduler.task.helper.OneTimeTask;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import java.time.Duration;
import java.time.Instant;
import javax.sql.DataSource;

public class EnableImmediateExecutionMain
extends Example {
    public static final TaskDescriptor<Void> DESCRIPTOR = TaskDescriptor.of((String)"my_task");

    public static void main(String[] args) {
        new EnableImmediateExecutionMain().runWithDatasource();
    }

    @Override
    public void run(DataSource dataSource) {
        OneTimeTask onetimeTask = Tasks.oneTime(DESCRIPTOR).execute((taskInstance, executionContext) -> System.out.println("Executed!"));
        Scheduler scheduler = Scheduler.create((DataSource)dataSource, (Task[])new Task[]{onetimeTask}).pollingInterval(Duration.ofSeconds(20L)).enableImmediateExecution().registerShutdownHook().build();
        scheduler.start();
        this.sleep(2000);
        System.out.println("Scheduling task to executed immediately.");
        scheduler.schedule(DESCRIPTOR.instance("1").scheduledTo(Instant.now()));
    }
}

