/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples.kotlin;

import com.github.kagkarlsson.scheduler.serializer.Serializer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/github/kagkarlsson/examples/kotlin/KotlinSerializer;", "Lcom/github/kagkarlsson/scheduler/serializer/Serializer;", "()V", "CHARSET", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "getCHARSET", "()Ljava/nio/charset/Charset;", "deserialize", "T", "clazz", "Ljava/lang/Class;", "serializedData", "", "(Ljava/lang/Class;[B)Ljava/lang/Object;", "serialize", "data", "", "features"})
public final class KotlinSerializer
implements Serializer {
    private final Charset CHARSET = StandardCharsets.UTF_8;

    public final Charset getCHARSET() {
        return this.CHARSET;
    }

    @NotNull
    public byte[] serialize(@NotNull Object data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        KSerializer serializer2 = SerializersKt.serializer((Type)data.getClass());
        String string = Json.Default.encodeToString((SerializationStrategy)serializer2, data);
        Charset charset = this.CHARSET;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"CHARSET");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    public <T> T deserialize(@NotNull Class<T> clazz, @NotNull byte[] serializedData) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)serializedData, (String)"serializedData");
        KSerializer kSerializer = SerializersKt.serializer((Type)clazz);
        Intrinsics.checkNotNull((Object)kSerializer, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of com.github.kagkarlsson.examples.kotlin.KotlinSerializer.deserialize>");
        KSerializer deserializer = kSerializer;
        DeserializationStrategy deserializationStrategy = (DeserializationStrategy)deserializer;
        Charset charset = this.CHARSET;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"CHARSET");
        Charset charset2 = charset;
        return (T)Json.Default.decodeFromString(deserializationStrategy, new String(serializedData, charset2));
    }
}

