/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples;

import com.github.kagkarlsson.examples.helpers.Example;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.SchedulerClient;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskDescriptor;
import com.github.kagkarlsson.scheduler.task.helper.OneTimeTask;
import com.github.kagkarlsson.scheduler.task.helper.RecurringTask;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.FixedDelay;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import java.time.Duration;
import java.time.Instant;
import javax.sql.DataSource;

public class SpawningOtherTasksMain
extends Example {
    public static final TaskDescriptor<Integer> PRINTER_TASK = TaskDescriptor.of((String)"printer", Integer.class);

    public static void main(String[] args) {
        new SpawningOtherTasksMain().runWithDatasource();
    }

    @Override
    public void run(DataSource dataSource) {
        OneTimeTask printer = Tasks.oneTime(PRINTER_TASK).execute((taskInstance, executionContext) -> System.out.println("Printer: " + taskInstance.getData()));
        RecurringTask spawner = Tasks.recurring((String)"spawner", (Schedule)FixedDelay.ofSeconds((int)5)).execute((taskInstance, executionContext) -> {
            SchedulerClient client = executionContext.getSchedulerClient();
            long id = System.currentTimeMillis();
            System.out.println("Scheduling printer executions.");
            for (int i = 0; i < 5; ++i) {
                client.scheduleIfNotExists(PRINTER_TASK.instance("print" + id + i).data((Object)i).scheduledTo(Instant.now()));
            }
        });
        Scheduler scheduler = Scheduler.create((DataSource)dataSource, (Task[])new Task[]{printer}).pollingInterval(Duration.ofSeconds(1L)).startTasks((Task[])new RecurringTask[]{spawner}).registerShutdownHook().build();
        scheduler.start();
    }
}

