/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples;

import com.github.kagkarlsson.examples.helpers.Example;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.helper.RecurringTaskWithPersistentSchedule;
import com.github.kagkarlsson.scheduler.task.helper.ScheduleAndData;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.FixedDelay;
import com.github.kagkarlsson.scheduler.task.schedule.Schedules;
import java.time.Duration;
import javax.sql.DataSource;

public class RecurringTaskWithPersistentScheduleMain
extends Example {
    public static void main(String[] args) {
        new RecurringTaskWithPersistentScheduleMain().runWithDatasource();
    }

    @Override
    public void run(DataSource dataSource) {
        RecurringTaskWithPersistentSchedule task = Tasks.recurringWithPersistentSchedule((String)"dynamic-recurring-task", ScheduleAndNoData.class).execute((taskInstance, executionContext) -> System.out.println("Instance: '" + taskInstance.getId() + "' ran using persistent schedule: " + ((ScheduleAndNoData)taskInstance.getData()).getSchedule()));
        Scheduler scheduler = Scheduler.create((DataSource)dataSource, (Task[])new Task[]{task}).pollingInterval(Duration.ofSeconds(1L)).registerShutdownHook().build();
        scheduler.start();
        this.sleep(2000);
        scheduler.schedule(task.schedulableInstance("id1", (ScheduleAndData)new ScheduleAndNoData(Schedules.fixedDelay((Duration)Duration.ofSeconds(1L)))));
        scheduler.schedule(task.schedulableInstance("id2", (ScheduleAndData)new ScheduleAndNoData(Schedules.fixedDelay((Duration)Duration.ofSeconds(6L)))));
    }

    public static class ScheduleAndNoData
    implements ScheduleAndData {
        private static final long serialVersionUID = 1L;
        private final FixedDelay schedule;

        private ScheduleAndNoData() {
            this(null);
        }

        public ScheduleAndNoData(FixedDelay schedule) {
            this.schedule = schedule;
        }

        public FixedDelay getSchedule() {
            return this.schedule;
        }

        public Object getData() {
            return null;
        }
    }
}

