/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.testhelper;

import com.github.kagkarlsson.scheduler.JdbcTaskRepository;
import com.github.kagkarlsson.scheduler.SchedulerBuilder;
import com.github.kagkarlsson.scheduler.SchedulerName;
import com.github.kagkarlsson.scheduler.TaskResolver;
import com.github.kagkarlsson.scheduler.jdbc.DefaultJdbcCustomization;
import com.github.kagkarlsson.scheduler.logging.LogLevel;
import com.github.kagkarlsson.scheduler.stats.StatsRegistry;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.testhelper.ManualScheduler;
import com.github.kagkarlsson.scheduler.testhelper.SettableClock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public class TestHelper {
    public static ManualSchedulerBuilder createManualScheduler(DataSource dataSource, Task<?> ... knownTasks) {
        return new ManualSchedulerBuilder(dataSource, Arrays.asList(knownTasks));
    }

    public static ManualSchedulerBuilder createManualScheduler(DataSource dataSource, List<Task<?>> knownTasks) {
        return new ManualSchedulerBuilder(dataSource, knownTasks);
    }

    private static class DirectExecutorService
    extends AbstractExecutorService {
        private DirectExecutorService() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return new ArrayList<Runnable>();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }

    public static class ManualSchedulerBuilder
    extends SchedulerBuilder {
        private SettableClock clock;

        public ManualSchedulerBuilder(DataSource dataSource, List<Task<?>> knownTasks) {
            super(dataSource, knownTasks);
        }

        public ManualSchedulerBuilder clock(SettableClock clock) {
            this.clock = clock;
            return this;
        }

        @Override
        public <T extends Task<?>> ManualSchedulerBuilder startTasks(List<T> startTasks) {
            super.startTasks(startTasks);
            return this;
        }

        @Override
        public ManualSchedulerBuilder statsRegistry(StatsRegistry statsRegistry) {
            this.statsRegistry = statsRegistry;
            return this;
        }

        @Override
        public ManualScheduler build() {
            TaskResolver taskResolver = new TaskResolver(this.statsRegistry, this.clock, this.knownTasks);
            JdbcTaskRepository schedulerTaskRepository = new JdbcTaskRepository(this.dataSource, true, new DefaultJdbcCustomization(), this.tableName, taskResolver, new SchedulerName.Fixed("manual"), this.serializer);
            JdbcTaskRepository clientTaskRepository = new JdbcTaskRepository(this.dataSource, this.commitWhenAutocommitDisabled, new DefaultJdbcCustomization(), this.tableName, taskResolver, new SchedulerName.Fixed("manual"), this.serializer);
            return new ManualScheduler(this.clock, schedulerTaskRepository, clientTaskRepository, taskResolver, this.executorThreads, new DirectExecutorService(), this.schedulerName, this.waiter, this.heartbeatInterval, this.enableImmediateExecution, this.statsRegistry, this.pollingLimit, this.deleteUnresolvedAfter, LogLevel.DEBUG, true, this.startTasks);
        }

        public ManualScheduler start() {
            ManualScheduler scheduler = this.build();
            scheduler.start();
            return scheduler;
        }
    }
}

