/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.ExecutorUtils;
import com.github.kagkarlsson.scheduler.JdbcTaskRepository;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.SchedulerName;
import com.github.kagkarlsson.scheduler.Serializer;
import com.github.kagkarlsson.scheduler.SystemClock;
import com.github.kagkarlsson.scheduler.TaskResolver;
import com.github.kagkarlsson.scheduler.Waiter;
import com.github.kagkarlsson.scheduler.jdbc.AutodetectJdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.JdbcCustomization;
import com.github.kagkarlsson.scheduler.stats.StatsRegistry;
import com.github.kagkarlsson.scheduler.task.OnStartup;
import com.github.kagkarlsson.scheduler.task.Task;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerBuilder.class);
    private static final int POLLING_CONCURRENCY_MULTIPLIER = 3;
    public static final Duration DEFAULT_POLLING_INTERVAL = Duration.ofSeconds(10L);
    public static final Duration DEFAULT_HEARTBEAT_INTERVAL = Duration.ofMinutes(5L);
    public static final Duration DEFAULT_DELETION_OF_UNRESOLVED_TASKS_DURATION = Duration.ofDays(14L);
    public static final Duration SHUTDOWN_MAX_WAIT = Duration.ofMinutes(30L);
    protected Clock clock = new SystemClock();
    protected final DataSource dataSource;
    protected SchedulerName schedulerName;
    protected int executorThreads = 10;
    protected final List<Task<?>> knownTasks = new ArrayList();
    protected final List<OnStartup> startTasks = new ArrayList<OnStartup>();
    protected Waiter waiter = new Waiter(DEFAULT_POLLING_INTERVAL, this.clock);
    protected int pollingLimit;
    protected boolean useDefaultPollingLimit;
    protected StatsRegistry statsRegistry = StatsRegistry.NOOP;
    protected Duration heartbeatInterval = DEFAULT_HEARTBEAT_INTERVAL;
    protected Serializer serializer = Serializer.DEFAULT_JAVA_SERIALIZER;
    protected String tableName = "scheduled_tasks";
    protected boolean enableImmediateExecution = false;
    protected ExecutorService executorService;
    protected Duration deleteUnresolvedAfter = DEFAULT_DELETION_OF_UNRESOLVED_TASKS_DURATION;
    protected JdbcCustomization jdbcCustomization = null;
    protected Duration shutdownMaxWait = SHUTDOWN_MAX_WAIT;
    protected boolean commitWhenAutocommitDisabled = false;

    public SchedulerBuilder(DataSource dataSource, List<Task<?>> knownTasks) {
        this.dataSource = dataSource;
        this.knownTasks.addAll(knownTasks);
        this.pollingLimit = this.calculatePollingLimit();
        this.useDefaultPollingLimit = true;
    }

    @SafeVarargs
    public final <T extends Task<?>> SchedulerBuilder startTasks(T ... startTasks) {
        return this.startTasks(Arrays.asList(startTasks));
    }

    public <T extends Task<?>> SchedulerBuilder startTasks(List<T> startTasks) {
        this.knownTasks.addAll(startTasks);
        this.startTasks.addAll(startTasks);
        return this;
    }

    public SchedulerBuilder pollingInterval(Duration pollingInterval) {
        this.waiter = new Waiter(pollingInterval, this.clock);
        return this;
    }

    public SchedulerBuilder pollingLimit(int pollingLimit) {
        if (pollingLimit <= 0) {
            throw new IllegalArgumentException("pollingLimit must be a positive integer");
        }
        this.pollingLimit = pollingLimit;
        this.useDefaultPollingLimit = false;
        return this;
    }

    private int calculatePollingLimit() {
        return this.executorThreads * 3;
    }

    public SchedulerBuilder heartbeatInterval(Duration duration) {
        this.heartbeatInterval = duration;
        return this;
    }

    public SchedulerBuilder threads(int numberOfThreads) {
        this.executorThreads = numberOfThreads;
        if (this.useDefaultPollingLimit) {
            this.pollingLimit = this.calculatePollingLimit();
        }
        return this;
    }

    public SchedulerBuilder executorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public SchedulerBuilder statsRegistry(StatsRegistry statsRegistry) {
        this.statsRegistry = statsRegistry;
        return this;
    }

    public SchedulerBuilder schedulerName(SchedulerName schedulerName) {
        this.schedulerName = schedulerName;
        return this;
    }

    public SchedulerBuilder serializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public SchedulerBuilder tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public SchedulerBuilder enableImmediateExecution() {
        this.enableImmediateExecution = true;
        return this;
    }

    public SchedulerBuilder deleteUnresolvedAfter(Duration deleteAfter) {
        this.deleteUnresolvedAfter = deleteAfter;
        return this;
    }

    public SchedulerBuilder jdbcCustomization(JdbcCustomization jdbcCustomization) {
        this.jdbcCustomization = jdbcCustomization;
        return this;
    }

    public SchedulerBuilder shutdownMaxWait(Duration shutdownMaxWait) {
        this.shutdownMaxWait = shutdownMaxWait;
        return this;
    }

    public SchedulerBuilder commitWhenAutocommitDisabled(boolean commitWhenAutocommitDisabled) {
        this.commitWhenAutocommitDisabled = commitWhenAutocommitDisabled;
        return this;
    }

    public Scheduler build() {
        if (this.pollingLimit < this.executorThreads) {
            LOG.warn("Polling-limit is less than number of threads. Should be equal or higher.");
        }
        if (this.schedulerName == null) {
            this.schedulerName = new SchedulerName.Hostname();
        }
        TaskResolver taskResolver = new TaskResolver(this.statsRegistry, this.clock, this.knownTasks);
        JdbcCustomization jdbcCustomization = Optional.ofNullable(this.jdbcCustomization).orElseGet(() -> new AutodetectJdbcCustomization(this.dataSource));
        JdbcTaskRepository schedulerTaskRepository = new JdbcTaskRepository(this.dataSource, true, jdbcCustomization, this.tableName, taskResolver, this.schedulerName, this.serializer);
        JdbcTaskRepository clientTaskRepository = new JdbcTaskRepository(this.dataSource, this.commitWhenAutocommitDisabled, jdbcCustomization, this.tableName, taskResolver, this.schedulerName, this.serializer);
        ExecutorService candidateExecutorService = this.executorService;
        if (candidateExecutorService == null) {
            candidateExecutorService = Executors.newFixedThreadPool(this.executorThreads, ExecutorUtils.defaultThreadFactoryWithPrefix("db-scheduler-"));
        }
        LOG.info("Creating scheduler with configuration: threads={}, pollInterval={}s, heartbeat={}s enable-immediate-execution={}, table-name={}, name={}", new Object[]{this.executorThreads, this.waiter.getWaitDuration().getSeconds(), this.heartbeatInterval.getSeconds(), this.enableImmediateExecution, this.tableName, this.schedulerName.getName()});
        return new Scheduler(this.clock, schedulerTaskRepository, clientTaskRepository, taskResolver, this.executorThreads, candidateExecutorService, this.schedulerName, this.waiter, this.heartbeatInterval, this.enableImmediateExecution, this.statsRegistry, this.pollingLimit, this.deleteUnresolvedAfter, this.shutdownMaxWait, this.startTasks);
    }
}

