/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.shaded.cronutils.model.time.generator;

import com.github.kagkarlsson.shaded.cronutils.Function;
import com.github.kagkarlsson.shaded.cronutils.model.field.CronField;
import com.github.kagkarlsson.shaded.cronutils.model.field.expression.Always;
import com.github.kagkarlsson.shaded.cronutils.model.field.expression.And;
import com.github.kagkarlsson.shaded.cronutils.model.field.expression.Between;
import com.github.kagkarlsson.shaded.cronutils.model.field.expression.Every;
import com.github.kagkarlsson.shaded.cronutils.model.field.expression.FieldExpression;
import com.github.kagkarlsson.shaded.cronutils.model.field.expression.On;
import com.github.kagkarlsson.shaded.cronutils.model.time.generator.AlwaysFieldValueGenerator;
import com.github.kagkarlsson.shaded.cronutils.model.time.generator.BetweenFieldValueGenerator;
import com.github.kagkarlsson.shaded.cronutils.model.time.generator.EveryFieldValueGenerator;
import com.github.kagkarlsson.shaded.cronutils.model.time.generator.FieldValueGenerator;
import com.github.kagkarlsson.shaded.cronutils.model.time.generator.NoSuchValueException;
import com.github.kagkarlsson.shaded.cronutils.model.time.generator.OnFieldValueGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AndFieldValueGenerator
extends FieldValueGenerator {
    private static final Logger log = LoggerFactory.getLogger(AndFieldValueGenerator.class);

    public AndFieldValueGenerator(CronField cronField) {
        super(cronField);
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        List<Integer> candidates = this.computeCandidates(fieldValueGenerator -> {
            try {
                return fieldValueGenerator.generateNextValue(reference);
            }
            catch (NoSuchValueException e) {
                return Integer.MIN_VALUE;
            }
        });
        if (candidates.isEmpty()) {
            throw new NoSuchValueException();
        }
        return candidates.get(0);
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        List<Integer> candidates = this.computeCandidates(candidateGenerator -> {
            try {
                return candidateGenerator.generatePreviousValue(reference);
            }
            catch (NoSuchValueException e) {
                return Integer.MIN_VALUE;
            }
        });
        if (candidates.isEmpty()) {
            throw new NoSuchValueException();
        }
        return candidates.get(candidates.size() - 1);
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        try {
            int reference = this.generateNextValue(start);
            while (reference < end) {
                values.add(reference);
                reference = this.generateNextValue(reference);
            }
        }
        catch (NoSuchValueException e) {
            log.debug("Catched expected exception while generating candidates", (Throwable)e);
        }
        return values;
    }

    @Override
    public boolean isMatch(int value) {
        And and = (And)this.cronField.getExpression();
        boolean match = false;
        for (FieldExpression expression : and.getExpressions()) {
            match = match || this.createCandidateGeneratorInstance(new CronField(this.cronField.getField(), expression, this.cronField.getConstraints())).isMatch(value);
        }
        return match;
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof And;
    }

    private List<Integer> computeCandidates(Function<FieldValueGenerator, Integer> function) {
        And and = (And)this.cronField.getExpression();
        ArrayList<Integer> candidates = new ArrayList<Integer>();
        for (FieldExpression expression : and.getExpressions()) {
            candidates.add(function.apply(this.createCandidateGeneratorInstance(new CronField(this.cronField.getField(), expression, this.cronField.getConstraints()))));
        }
        ArrayList<Integer> filteredCandidates = new ArrayList<Integer>();
        for (Integer candidate : candidates) {
            if (candidate < 0) continue;
            filteredCandidates.add(candidate);
        }
        Collections.sort(filteredCandidates);
        return filteredCandidates;
    }

    private FieldValueGenerator createCandidateGeneratorInstance(CronField cronField) {
        FieldExpression expression = cronField.getExpression();
        if (expression instanceof Always) {
            return new AlwaysFieldValueGenerator(cronField);
        }
        if (expression instanceof Between) {
            return new BetweenFieldValueGenerator(cronField);
        }
        if (expression instanceof Every) {
            return new EveryFieldValueGenerator(cronField);
        }
        if (expression instanceof On) {
            return new OnFieldValueGenerator(cronField);
        }
        throw new IllegalArgumentException(String.format("FieldExpression %s not supported!", expression.getClass()));
    }
}

