/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.ExecutionOperations;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CompletionHandler<T> {
    public void complete(ExecutionComplete var1, ExecutionOperations<T> var2);

    public static class OnCompleteReschedule<T>
    implements CompletionHandler<T> {
        private static final Logger LOG = LoggerFactory.getLogger(OnCompleteReschedule.class);
        private final Schedule schedule;

        public OnCompleteReschedule(Schedule schedule) {
            this.schedule = schedule;
        }

        @Override
        public void complete(ExecutionComplete executionComplete, ExecutionOperations<T> executionOperations) {
            Instant nextExecution = this.schedule.getNextExecutionTime(executionComplete);
            LOG.debug("Rescheduling task {} to {}", (Object)executionComplete.getExecution().taskInstance, (Object)nextExecution);
            executionOperations.reschedule(executionComplete, nextExecution);
        }
    }

    public static class OnCompleteRemove<T>
    implements CompletionHandler<T> {
        @Override
        public void complete(ExecutionComplete executionComplete, ExecutionOperations<T> executionOperations) {
            executionOperations.stop();
        }
    }
}

