/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task.schedule;

import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Daily
implements Schedule {
    private final List<LocalTime> times;

    public Daily(LocalTime ... times) {
        this(Arrays.asList(times));
    }

    public Daily(List<LocalTime> times) {
        if (times.size() < 1) {
            throw new IllegalArgumentException("times cannot be empty");
        }
        this.times = times.stream().sorted().collect(Collectors.toList());
    }

    @Override
    public Instant getNextExecutionTime(ExecutionComplete executionComplete) {
        ZoneId zone = ZoneId.systemDefault();
        Instant timeDone = executionComplete.getTimeDone();
        LocalDate doneDate = timeDone.atZone(zone).toLocalDate();
        for (LocalTime time : this.times) {
            Instant nextTimeCandidate = ZonedDateTime.of(doneDate, time, zone).toInstant();
            if (!nextTimeCandidate.isAfter(timeDone)) continue;
            return nextTimeCandidate;
        }
        return ZonedDateTime.of(doneDate, this.times.get(0), zone).plusDays(1L).toInstant();
    }
}

