/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task.helper;

import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.DeadExecutionHandler;
import com.github.kagkarlsson.scheduler.task.ExecutionContext;
import com.github.kagkarlsson.scheduler.task.ExecutionHandler;
import com.github.kagkarlsson.scheduler.task.FailureHandler;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import com.github.kagkarlsson.scheduler.task.VoidExecutionHandler;
import com.github.kagkarlsson.scheduler.task.helper.CustomTask;
import com.github.kagkarlsson.scheduler.task.helper.OneTimeTask;
import com.github.kagkarlsson.scheduler.task.helper.RecurringTask;
import com.github.kagkarlsson.scheduler.task.helper.ScheduleOnStartup;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import java.time.Duration;

public class Tasks {
    public static final Duration DEFAULT_RETRY_INTERVAL = Duration.ofMinutes(5L);

    public static RecurringTaskBuilder<Void> recurring(String name, Schedule schedule) {
        return new RecurringTaskBuilder<Void>(name, schedule, Void.class);
    }

    public static <T> RecurringTaskBuilder<T> recurring(String name, Schedule schedule, Class<T> dataClass) {
        return new RecurringTaskBuilder<T>(name, schedule, dataClass);
    }

    public static OneTimeTaskBuilder<Void> oneTime(String name) {
        return new OneTimeTaskBuilder<Void>(name, Void.class);
    }

    public static <T> OneTimeTaskBuilder<T> oneTime(String name, Class<T> dataClass) {
        return new OneTimeTaskBuilder<T>(name, dataClass);
    }

    public static <T> TaskBuilder<T> custom(String name, Class<T> dataClass) {
        return new TaskBuilder<T>(name, dataClass);
    }

    public static class TaskBuilder<T> {
        private final String name;
        private Class<T> dataClass;
        private FailureHandler<T> onFailure;
        private DeadExecutionHandler<T> onDeadExecution;
        private ScheduleOnStartup<T> onStartup;

        public TaskBuilder(String name, Class<T> dataClass) {
            this.name = name;
            this.dataClass = dataClass;
            this.onDeadExecution = new DeadExecutionHandler.ReviveDeadExecution();
            this.onFailure = new FailureHandler.OnFailureRetryLater(DEFAULT_RETRY_INTERVAL);
        }

        public TaskBuilder<T> onFailureReschedule(Schedule schedule) {
            this.onFailure = new FailureHandler.OnFailureReschedule(schedule);
            return this;
        }

        public TaskBuilder<T> onDeadExecutionRevive() {
            this.onDeadExecution = new DeadExecutionHandler.ReviveDeadExecution();
            return this;
        }

        public TaskBuilder<T> onFailure(FailureHandler<T> failureHandler) {
            this.onFailure = failureHandler;
            return this;
        }

        public TaskBuilder<T> onDeadExecution(DeadExecutionHandler<T> deadExecutionHandler) {
            this.onDeadExecution = deadExecutionHandler;
            return this;
        }

        public TaskBuilder<T> scheduleOnStartup(String instance, T initialData) {
            this.onStartup = new ScheduleOnStartup<T>(instance, initialData);
            return this;
        }

        public CustomTask<T> execute(final ExecutionHandler<T> executionHandler) {
            return new CustomTask<T>(this.name, this.dataClass, this.onStartup, this.onFailure, this.onDeadExecution){

                @Override
                public CompletionHandler<T> execute(TaskInstance<T> taskInstance, ExecutionContext executionContext) {
                    return executionHandler.execute(taskInstance, executionContext);
                }
            };
        }
    }

    public static class OneTimeTaskBuilder<T> {
        private final String name;
        private Class<T> dataClass;
        private FailureHandler<T> onFailure;
        private DeadExecutionHandler<T> onDeadExecution;

        public OneTimeTaskBuilder(String name, Class<T> dataClass) {
            this.name = name;
            this.dataClass = dataClass;
            this.onDeadExecution = new DeadExecutionHandler.ReviveDeadExecution();
            this.onFailure = new FailureHandler.OnFailureRetryLater(DEFAULT_RETRY_INTERVAL);
        }

        public OneTimeTaskBuilder<T> onFailureRetryLater() {
            this.onFailure = new FailureHandler.OnFailureRetryLater(DEFAULT_RETRY_INTERVAL);
            return this;
        }

        public OneTimeTaskBuilder<T> onDeadExecutionRevive() {
            this.onDeadExecution = new DeadExecutionHandler.ReviveDeadExecution();
            return this;
        }

        public OneTimeTaskBuilder<T> onFailure(FailureHandler<T> failureHandler) {
            this.onFailure = failureHandler;
            return this;
        }

        public OneTimeTaskBuilder<T> onDeadExecution(DeadExecutionHandler<T> deadExecutionHandler) {
            this.onDeadExecution = deadExecutionHandler;
            return this;
        }

        public OneTimeTask<T> execute(final VoidExecutionHandler<T> executionHandler) {
            return new OneTimeTask<T>(this.name, this.dataClass, this.onFailure, this.onDeadExecution){

                @Override
                public void executeOnce(TaskInstance<T> taskInstance, ExecutionContext executionContext) {
                    executionHandler.execute(taskInstance, executionContext);
                }
            };
        }
    }

    public static class RecurringTaskBuilder<T> {
        private final String name;
        private final Schedule schedule;
        private Class<T> dataClass;
        private T initialData;
        private FailureHandler<T> onFailure;
        private DeadExecutionHandler<T> onDeadExecution;

        public RecurringTaskBuilder(String name, Schedule schedule, Class<T> dataClass) {
            this.name = name;
            this.schedule = schedule;
            this.dataClass = dataClass;
            this.onFailure = new FailureHandler.OnFailureReschedule(schedule);
            this.onDeadExecution = new DeadExecutionHandler.ReviveDeadExecution();
        }

        public RecurringTaskBuilder<T> onFailureReschedule() {
            this.onFailure = new FailureHandler.OnFailureReschedule(this.schedule);
            return this;
        }

        public RecurringTaskBuilder<T> onDeadExecutionRevive() {
            this.onDeadExecution = new DeadExecutionHandler.ReviveDeadExecution();
            return this;
        }

        public RecurringTaskBuilder<T> onFailure(FailureHandler<T> failureHandler) {
            this.onFailure = failureHandler;
            return this;
        }

        public RecurringTaskBuilder<T> onDeadExecution(DeadExecutionHandler<T> deadExecutionHandler) {
            this.onDeadExecution = deadExecutionHandler;
            return this;
        }

        public RecurringTaskBuilder<T> initialData(T initialData) {
            this.initialData = initialData;
            return this;
        }

        public RecurringTask<T> execute(final VoidExecutionHandler<T> executionHandler) {
            return new RecurringTask<T>(this.name, this.schedule, this.dataClass, this.initialData, this.onFailure, this.onDeadExecution){

                @Override
                public void executeRecurringly(TaskInstance<T> taskInstance, ExecutionContext executionContext) {
                    executionHandler.execute(taskInstance, executionContext);
                }
            };
        }
    }
}

