/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.JdbcTaskRepository;
import com.github.kagkarlsson.scheduler.SchedulerName;
import com.github.kagkarlsson.scheduler.Serializer;
import com.github.kagkarlsson.scheduler.TaskRepository;
import com.github.kagkarlsson.scheduler.TaskResolver;
import com.github.kagkarlsson.scheduler.task.Execution;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import com.github.kagkarlsson.scheduler.task.TaskInstanceId;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Optional;
import javax.sql.DataSource;

public interface SchedulerClient {
    public <T> void schedule(TaskInstance<T> var1, Instant var2);

    public void reschedule(TaskInstanceId var1, Instant var2);

    public void cancel(TaskInstanceId var1);

    public static class SchedulerClientName
    implements SchedulerName {
        @Override
        public String getName() {
            return "SchedulerClient";
        }
    }

    public static class StandardSchedulerClient
    implements SchedulerClient {
        protected final TaskRepository taskRepository;

        StandardSchedulerClient(TaskRepository taskRepository) {
            this.taskRepository = taskRepository;
        }

        @Override
        public <T> void schedule(TaskInstance<T> taskInstance, Instant executionTime) {
            this.taskRepository.createIfNotExists(new Execution(executionTime, taskInstance));
        }

        @Override
        public void reschedule(TaskInstanceId taskInstanceId, Instant newExecutionTime) {
            String instanceId;
            String taskName = taskInstanceId.getTaskName();
            Optional<Execution> execution = this.taskRepository.getExecution(taskName, instanceId = taskInstanceId.getId());
            if (execution.isPresent()) {
                if (execution.get().isPicked()) {
                    throw new RuntimeException(String.format("Could not reschedule, the execution with name '%s' and id '%s' is currently executing", taskName, instanceId));
                }
            } else {
                throw new RuntimeException(String.format("Could not reschedule - no task with name '%s' and id '%s' was found.", taskName, instanceId));
            }
            this.taskRepository.reschedule(execution.get(), newExecutionTime, null, null);
        }

        @Override
        public void cancel(TaskInstanceId taskInstanceId) {
            String instanceId;
            String taskName = taskInstanceId.getTaskName();
            Optional<Execution> execution = this.taskRepository.getExecution(taskName, instanceId = taskInstanceId.getId());
            if (execution.isPresent()) {
                if (execution.get().isPicked()) {
                    throw new RuntimeException(String.format("Could not cancel schedule, the execution with name '%s' and id '%s' is currently executing", taskName, instanceId));
                }
            } else {
                throw new RuntimeException(String.format("Could not cancel schedule - no task with name '%s' and id '%s' was found.", taskName, instanceId));
            }
            this.taskRepository.remove(execution.get());
        }
    }

    public static class Builder {
        private final DataSource dataSource;
        private final Serializer serializer = Serializer.DEFAULT_JAVA_SERIALIZER;

        private Builder(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public static Builder create(DataSource dataSource) {
            return new Builder(dataSource);
        }

        public SchedulerClient build() {
            TaskResolver taskResolver = new TaskResolver(new ArrayList());
            JdbcTaskRepository taskRepository = new JdbcTaskRepository(this.dataSource, taskResolver, new SchedulerClientName(), this.serializer);
            return new StandardSchedulerClient(taskRepository);
        }
    }
}

