/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskInstanceId;
import java.util.Objects;
import java.util.function.Supplier;

public final class TaskInstance<T>
implements TaskInstanceId {
    private final Task<T> task;
    private final String id;
    private final Supplier<T> dataSupplier;
    private final Supplier<byte[]> serializedDataSupplier;

    public TaskInstance(Task<T> task, String id) {
        this((Task<Object>)task, id, null);
    }

    public TaskInstance(Task<T> task, String id, T data) {
        this.task = task;
        this.id = id;
        this.dataSupplier = () -> data;
        this.serializedDataSupplier = TaskInstance.memoize(() -> this.task.serializer.serialize(data));
    }

    public TaskInstance(Task<T> task, String id, byte[] serializedData) {
        this.task = task;
        this.id = id;
        this.serializedDataSupplier = () -> serializedData;
        this.dataSupplier = TaskInstance.memoize(() -> this.task.serializer.deserialize(serializedData));
    }

    public String getTaskAndInstance() {
        return this.task.getName() + "_" + this.id;
    }

    public Task getTask() {
        return this.task;
    }

    @Override
    public String getTaskName() {
        return this.task.getName();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public T getData() {
        return this.dataSupplier.get();
    }

    public byte[] getSerializedData() {
        return this.serializedDataSupplier.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskInstance that = (TaskInstance)o;
        return Objects.equals(this.task.getName(), that.task.getName()) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.task.getName(), this.id);
    }

    public String toString() {
        return "TaskInstance: task=" + this.task.getName() + ", id=" + this.id;
    }

    private static <T> Supplier<T> memoize(final Supplier<T> original) {
        return new Supplier<T>(){
            Supplier<T> delegate = this::firstTime;
            boolean initialized;

            @Override
            public T get() {
                return this.delegate.get();
            }

            private synchronized T firstTime() {
                if (!this.initialized) {
                    Object value = original.get();
                    this.delegate = () -> value;
                    this.initialized = true;
                }
                return this.delegate.get();
            }
        };
    }
}

