/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.DeadExecutionHandler;
import com.github.kagkarlsson.scheduler.task.FailureHandler;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskInstance;

public abstract class AbstractTask<T>
implements Task<T> {
    protected final String name;
    private final FailureHandler<T> failureHandler;
    private final DeadExecutionHandler<T> deadExecutionHandler;
    private final Class<T> dataClass;

    public AbstractTask(String name, Class<T> dataClass, FailureHandler<T> failureHandler, DeadExecutionHandler<T> deadExecutionHandler) {
        this.name = name;
        this.dataClass = dataClass;
        this.failureHandler = failureHandler;
        this.deadExecutionHandler = deadExecutionHandler;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<T> getDataClass() {
        return this.dataClass;
    }

    @Override
    public TaskInstance<T> instance(String id) {
        return this.instanceBuilder(id).build();
    }

    @Override
    public TaskInstance<T> instance(String id, T data) {
        return this.instanceBuilder(id).data(data).build();
    }

    @Override
    public TaskInstance.Builder<T> instanceBuilder(String id) {
        return new TaskInstance.Builder(this.name, id).priority(this.getDefaultPriority());
    }

    @Override
    public FailureHandler<T> getFailureHandler() {
        return this.failureHandler;
    }

    @Override
    public DeadExecutionHandler<T> getDeadExecutionHandler() {
        return this.deadExecutionHandler;
    }

    public String toString() {
        return "Task name=" + this.getName();
    }
}

