/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.jdbc;

import com.github.kagkarlsson.scheduler.jdbc.DefaultJdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.Queries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQL8JdbcCustomization
extends DefaultJdbcCustomization {
    private static final Logger LOG = LoggerFactory.getLogger(MySQL8JdbcCustomization.class);

    public MySQL8JdbcCustomization(boolean persistTimestampInUTC) {
        super(persistTimestampInUTC);
    }

    @Override
    public String getName() {
        return "MySQL => v8";
    }

    @Override
    public String getQueryLimitPart(int limit) {
        return Queries.postgresSqlLimitPart(limit);
    }

    @Override
    public boolean supportsGenericLockAndFetch() {
        return false;
    }

    @Override
    public String createGenericSelectForUpdateQuery(String tableName, int limit, String requiredAndCondition, boolean orderByPriority) {
        return Queries.selectForUpdate(tableName, Queries.ansiSqlOrderPart(orderByPriority), Queries.postgresSqlLimitPart(limit), requiredAndCondition, " FOR UPDATE SKIP LOCKED ", null);
    }
}

