/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.jdbc;

import com.github.kagkarlsson.scheduler.jdbc.DefaultJdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.Queries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MariaDBJdbcCustomization
extends DefaultJdbcCustomization {
    private static final Logger LOG = LoggerFactory.getLogger(MariaDBJdbcCustomization.class);

    public MariaDBJdbcCustomization(boolean persistTimestampInUTC) {
        super(persistTimestampInUTC);
    }

    @Override
    public String getName() {
        return "MariaDB";
    }

    @Override
    public String getQueryLimitPart(int limit) {
        return Queries.postgresSqlLimitPart(limit);
    }

    @Override
    public boolean supportsGenericLockAndFetch() {
        return false;
    }

    @Override
    public String createGenericSelectForUpdateQuery(String tableName, int limit, String requiredAndCondition, boolean orderByPriority) {
        return Queries.selectForUpdate(tableName, Queries.ansiSqlOrderPart(orderByPriority), Queries.postgresSqlLimitPart(limit), requiredAndCondition, " FOR UPDATE SKIP LOCKED ", null);
    }
}

