/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.testhelper;

import com.github.kagkarlsson.scheduler.PollingStrategyConfig;
import com.github.kagkarlsson.scheduler.SchedulerBuilder;
import com.github.kagkarlsson.scheduler.SchedulerName;
import com.github.kagkarlsson.scheduler.TaskResolver;
import com.github.kagkarlsson.scheduler.jdbc.DefaultJdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.JdbcTaskRepository;
import com.github.kagkarlsson.scheduler.logging.LogLevel;
import com.github.kagkarlsson.scheduler.stats.StatsRegistry;
import com.github.kagkarlsson.scheduler.stats.StatsRegistryAdapter;
import com.github.kagkarlsson.scheduler.task.OnStartup;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.testhelper.ManualScheduler;
import com.github.kagkarlsson.scheduler.testhelper.SettableClock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public class TestHelper {
    public static ManualSchedulerBuilder createManualScheduler(DataSource dataSource, Task<?> ... knownTasks) {
        return new ManualSchedulerBuilder(dataSource, Arrays.asList(knownTasks));
    }

    public static ManualSchedulerBuilder createManualScheduler(DataSource dataSource, List<Task<?>> knownTasks) {
        return new ManualSchedulerBuilder(dataSource, knownTasks);
    }

    private static class ThrowingScheduledExecutorService
    extends BaseExecutorService
    implements ScheduledExecutorService {
        private ThrowingScheduledExecutorService() {
        }

        private RuntimeException doNotUseError() {
            return new RuntimeException("This ExecutorService should never be used. The intention is to trigger the desired scheduler-operation manually, e.g scheduler.runAnyDueExecutions()");
        }

        @Override
        public void execute(Runnable command) {
            throw this.doNotUseError();
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            throw this.doNotUseError();
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            throw this.doNotUseError();
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            throw this.doNotUseError();
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            throw this.doNotUseError();
        }
    }

    private static class DirectExecutorService
    extends BaseExecutorService {
        private DirectExecutorService() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }

    private static abstract class BaseExecutorService
    extends AbstractExecutorService {
        private BaseExecutorService() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return new ArrayList<Runnable>();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return true;
        }
    }

    public static class ManualSchedulerBuilder
    extends SchedulerBuilder {
        private SettableClock clock;

        public ManualSchedulerBuilder(DataSource dataSource, List<Task<?>> knownTasks) {
            super(dataSource, knownTasks);
        }

        public ManualSchedulerBuilder clock(SettableClock clock) {
            this.clock = clock;
            return this;
        }

        @Override
        public <T extends Task<?> & OnStartup> ManualSchedulerBuilder startTasks(List<T> startTasks) {
            super.startTasks(startTasks);
            return this;
        }

        @Override
        public ManualSchedulerBuilder statsRegistry(StatsRegistry statsRegistry) {
            this.statsRegistry = statsRegistry;
            return this;
        }

        public ManualSchedulerBuilder pollingStrategy(PollingStrategyConfig pollingStrategyConfig) {
            this.pollingStrategyConfig = pollingStrategyConfig;
            return this;
        }

        @Override
        public ManualScheduler build() {
            TaskResolver taskResolver = new TaskResolver(this.statsRegistry, this.clock, this.knownTasks);
            JdbcTaskRepository schedulerTaskRepository = new JdbcTaskRepository(this.dataSource, true, new DefaultJdbcCustomization(false), this.tableName, taskResolver, new SchedulerName.Fixed("manual"), this.serializer, this.clock);
            JdbcTaskRepository clientTaskRepository = new JdbcTaskRepository(this.dataSource, this.commitWhenAutocommitDisabled, new DefaultJdbcCustomization(false), this.tableName, taskResolver, new SchedulerName.Fixed("manual"), this.serializer, this.clock);
            return new ManualScheduler(this.clock, schedulerTaskRepository, clientTaskRepository, taskResolver, this.executorThreads, new DirectExecutorService(), this.schedulerName, this.waiter, this.heartbeatInterval, this.enableImmediateExecution, List.of(new StatsRegistryAdapter(this.statsRegistry)), Optional.ofNullable(this.pollingStrategyConfig).orElse(PollingStrategyConfig.DEFAULT_FETCH), this.deleteUnresolvedAfter, LogLevel.DEBUG, true, this.startTasks, new ThrowingScheduledExecutorService(), new ThrowingScheduledExecutorService());
        }

        public ManualScheduler start() {
            ManualScheduler scheduler = this.build();
            scheduler.start();
            return scheduler;
        }
    }
}

