/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import com.github.kagkarlsson.scheduler.task.ExecutionOperations;
import com.github.kagkarlsson.scheduler.task.helper.ScheduleAndData;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface FailureHandler<T> {
    public void onFailure(ExecutionComplete var1, ExecutionOperations<T> var2);

    public static class OnFailureRescheduleUsingTaskDataSchedule<T extends ScheduleAndData>
    implements FailureHandler<T> {
        private static final Logger LOG = LoggerFactory.getLogger(CompletionHandler.OnCompleteReschedule.class);

        @Override
        public void onFailure(ExecutionComplete executionComplete, ExecutionOperations<T> executionOperations) {
            ScheduleAndData data = (ScheduleAndData)executionComplete.getExecution().taskInstance.getData();
            Instant nextExecutionTime = data.getSchedule().getNextExecutionTime(executionComplete);
            LOG.debug("Execution failed. Rescheduling task {} to {}", (Object)executionComplete.getExecution().taskInstance, (Object)nextExecutionTime);
            executionOperations.reschedule(executionComplete, nextExecutionTime);
        }
    }

    public static class OnFailureReschedule<T>
    implements FailureHandler<T> {
        private static final Logger LOG = LoggerFactory.getLogger(CompletionHandler.OnCompleteReschedule.class);
        private final Schedule schedule;

        public OnFailureReschedule(Schedule schedule) {
            this.schedule = schedule;
        }

        @Override
        public void onFailure(ExecutionComplete executionComplete, ExecutionOperations<T> executionOperations) {
            Instant nextExecution = this.schedule.getNextExecutionTime(executionComplete);
            LOG.debug("Execution failed. Rescheduling task {} to {}", (Object)executionComplete.getExecution().taskInstance, (Object)nextExecution);
            executionOperations.reschedule(executionComplete, nextExecution);
        }
    }

    public static class OnFailureRetryLater<T>
    implements FailureHandler<T> {
        private static final Logger LOG = LoggerFactory.getLogger(CompletionHandler.OnCompleteReschedule.class);
        private final Duration sleepDuration;

        public OnFailureRetryLater(Duration sleepDuration) {
            this.sleepDuration = sleepDuration;
        }

        @Override
        public void onFailure(ExecutionComplete executionComplete, ExecutionOperations<T> executionOperations) {
            Instant nextTry = executionComplete.getTimeDone().plus(this.sleepDuration);
            LOG.debug("Execution failed. Retrying task {} at {}", (Object)executionComplete.getExecution().taskInstance, (Object)nextTry);
            executionOperations.reschedule(executionComplete, nextTry);
        }
    }

    public static class MaxRetriesFailureHandler<T>
    implements FailureHandler<T> {
        private static final Logger LOG = LoggerFactory.getLogger(MaxRetriesFailureHandler.class);
        private final int maxRetries;
        private final FailureHandler<T> failureHandler;

        public MaxRetriesFailureHandler(int maxRetries, FailureHandler<T> failureHandler) {
            this.maxRetries = maxRetries;
            this.failureHandler = failureHandler;
        }

        @Override
        public void onFailure(ExecutionComplete executionComplete, ExecutionOperations<T> executionOperations) {
            int consecutiveFailures = executionComplete.getExecution().consecutiveFailures;
            int totalNumberOfFailures = consecutiveFailures + 1;
            if (totalNumberOfFailures > this.maxRetries) {
                LOG.error("Execution has failed {} times for task instance {}. Cancelling execution.", (Object)totalNumberOfFailures, (Object)executionComplete.getExecution().taskInstance);
                executionOperations.stop();
            } else {
                this.failureHandler.onFailure(executionComplete, executionOperations);
            }
        }
    }

    public static class ExponentialBackoffFailureHandler<T>
    implements FailureHandler<T> {
        private static final Logger LOG = LoggerFactory.getLogger(ExponentialBackoffFailureHandler.class);
        private static final double DEFAULT_MULTIPLIER = 1.5;
        private final Duration sleepDuration;
        private final double exponentialRate;

        public ExponentialBackoffFailureHandler(Duration sleepDuration) {
            this.sleepDuration = sleepDuration;
            this.exponentialRate = 1.5;
        }

        public ExponentialBackoffFailureHandler(Duration sleepDuration, double exponentialRate) {
            this.sleepDuration = sleepDuration;
            this.exponentialRate = exponentialRate;
        }

        @Override
        public void onFailure(ExecutionComplete executionComplete, ExecutionOperations<T> executionOperations) {
            long retryDurationMs = Math.round((double)this.sleepDuration.toMillis() * Math.pow(this.exponentialRate, executionComplete.getExecution().consecutiveFailures));
            Instant nextTry = executionComplete.getTimeDone().plusMillis(retryDurationMs);
            LOG.debug("Execution failed {}. Retrying task {} at {}", new Object[]{executionComplete.getTimeDone(), executionComplete.getExecution().taskInstance, nextTry});
            executionOperations.reschedule(executionComplete, nextTry);
        }
    }
}

