/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.jdbc;

import com.github.kagkarlsson.scheduler.jdbc.DefaultJdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.JdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.JdbcTaskRepositoryContext;
import com.github.kagkarlsson.scheduler.jdbc.MssqlJdbcCustomization;
import com.github.kagkarlsson.scheduler.jdbc.PostgreSqlJdbcCustomization;
import com.github.kagkarlsson.scheduler.task.Execution;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutodetectJdbcCustomization
implements JdbcCustomization {
    private static final Logger LOG = LoggerFactory.getLogger(AutodetectJdbcCustomization.class);
    public static final String MICROSOFT_SQL_SERVER = "Microsoft SQL Server";
    public static final String POSTGRESQL = "PostgreSQL";
    private final JdbcCustomization jdbcCustomization;

    public AutodetectJdbcCustomization(DataSource dataSource) {
        DefaultJdbcCustomization detectedCustomization = new DefaultJdbcCustomization();
        LOG.debug("Detecting database...");
        try (Connection c = dataSource.getConnection();){
            String databaseProductName = c.getMetaData().getDatabaseProductName();
            LOG.info("Detected database {}.", (Object)databaseProductName);
            if (databaseProductName.equals(MICROSOFT_SQL_SERVER)) {
                LOG.info("Using MSSQL jdbc-overrides.");
                detectedCustomization = new MssqlJdbcCustomization();
            } else if (databaseProductName.equals(POSTGRESQL)) {
                LOG.info("Using PostgreSQL jdbc-overrides.");
                detectedCustomization = new PostgreSqlJdbcCustomization();
            }
        }
        catch (SQLException e) {
            LOG.error("Failed to detect database via getDatabaseMetadata. Using default.", (Throwable)e);
        }
        this.jdbcCustomization = detectedCustomization;
    }

    @Override
    public void setInstant(PreparedStatement p, int index, Instant value) throws SQLException {
        this.jdbcCustomization.setInstant(p, index, value);
    }

    @Override
    public Instant getInstant(ResultSet rs, String columnName) throws SQLException {
        return this.jdbcCustomization.getInstant(rs, columnName);
    }

    @Override
    public void setTaskData(PreparedStatement p, int index, byte[] value) throws SQLException {
        this.jdbcCustomization.setTaskData(p, index, value);
    }

    @Override
    public byte[] getTaskData(ResultSet rs, String columnName) throws SQLException {
        return this.jdbcCustomization.getTaskData(rs, columnName);
    }

    @Override
    public boolean supportsExplicitQueryLimitPart() {
        return this.jdbcCustomization.supportsExplicitQueryLimitPart();
    }

    @Override
    public String getQueryLimitPart(int limit) {
        return this.jdbcCustomization.getQueryLimitPart(limit);
    }

    @Override
    public boolean supportsLockAndFetch() {
        return this.jdbcCustomization.supportsLockAndFetch();
    }

    @Override
    public List<Execution> lockAndFetch(JdbcTaskRepositoryContext ctx, Instant now, int limit) {
        return this.jdbcCustomization.lockAndFetch(ctx, now, limit);
    }

    @Override
    public String getName() {
        return this.jdbcCustomization.getName();
    }
}

