/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task.helper;

import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.DeadExecutionHandler;
import com.github.kagkarlsson.scheduler.task.ExecutionContext;
import com.github.kagkarlsson.scheduler.task.FailureHandler;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import java.time.Duration;

public abstract class OneTimeTask<T>
extends Task<T> {
    public OneTimeTask(String name, Class<T> dataClass) {
        this(name, dataClass, new FailureHandler.OnFailureRetryLater(Duration.ofMinutes(5L)), new DeadExecutionHandler.ReviveDeadExecution());
    }

    public OneTimeTask(String name, Class<T> dataClass, FailureHandler<T> failureHandler, DeadExecutionHandler<T> deadExecutionHandler) {
        super(name, dataClass, failureHandler, deadExecutionHandler);
    }

    @Override
    public CompletionHandler<T> execute(TaskInstance<T> taskInstance, ExecutionContext executionContext) {
        this.executeOnce(taskInstance, executionContext);
        return new CompletionHandler.OnCompleteRemove();
    }

    public abstract void executeOnce(TaskInstance<T> var1, ExecutionContext var2);

    @Override
    public String toString() {
        return "OneTimeTask name=" + this.getName();
    }
}

