/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.task.CompletionHandler;
import com.github.kagkarlsson.scheduler.task.DeadExecutionHandler;
import com.github.kagkarlsson.scheduler.task.ExecutionContext;
import com.github.kagkarlsson.scheduler.task.ExecutionHandler;
import com.github.kagkarlsson.scheduler.task.FailureHandler;
import com.github.kagkarlsson.scheduler.task.TaskInstance;

public abstract class Task<T>
implements ExecutionHandler<T> {
    protected final String name;
    private final FailureHandler<T> failureHandler;
    private final DeadExecutionHandler<T> deadExecutionHandler;
    private final Class<T> dataClass;

    public Task(String name, Class<T> dataClass, FailureHandler<T> failureHandler, DeadExecutionHandler<T> deadExecutionHandler) {
        this.name = name;
        this.dataClass = dataClass;
        this.failureHandler = failureHandler;
        this.deadExecutionHandler = deadExecutionHandler;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getDataClass() {
        return this.dataClass;
    }

    public TaskInstance<T> instance(String id) {
        return new TaskInstance(this.name, id);
    }

    public TaskInstance<T> instance(String id, T data) {
        return new TaskInstance<T>(this.name, id, data);
    }

    @Override
    public abstract CompletionHandler<T> execute(TaskInstance<T> var1, ExecutionContext var2);

    public FailureHandler<T> getFailureHandler() {
        return this.failureHandler;
    }

    public DeadExecutionHandler<T> getDeadExecutionHandler() {
        return this.deadExecutionHandler;
    }

    public String toString() {
        return "Task name=" + this.getName();
    }
}

