/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.JdbcTaskRepository;
import com.github.kagkarlsson.scheduler.SchedulerName;
import com.github.kagkarlsson.scheduler.TaskRepository;
import com.github.kagkarlsson.scheduler.TaskResolver;
import com.github.kagkarlsson.scheduler.task.Execution;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import java.time.Instant;
import java.util.ArrayList;
import javax.sql.DataSource;

public interface SchedulerClient {
    public void scheduleForExecution(Instant var1, TaskInstance var2);

    public static class SchedulerClientName
    implements SchedulerName {
        @Override
        public String getName() {
            return "SchedulerClient";
        }
    }

    public static class StandardSchedulerClient
    implements SchedulerClient {
        private TaskRepository taskRepository;

        StandardSchedulerClient(TaskRepository taskRepository) {
            this.taskRepository = taskRepository;
        }

        @Override
        public void scheduleForExecution(Instant exeecutionTime, TaskInstance taskInstance) {
            this.taskRepository.createIfNotExists(new Execution(exeecutionTime, taskInstance));
        }
    }

    public static class Builder {
        private DataSource dataSource;

        private Builder(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public static Builder create(DataSource dataSource) {
            return new Builder(dataSource);
        }

        public SchedulerClient build() {
            TaskResolver taskResolver = new TaskResolver(TaskResolver.OnCannotResolve.FAIL_ON_UNRESOLVED, new ArrayList<Task>());
            JdbcTaskRepository taskRepository = new JdbcTaskRepository(this.dataSource, taskResolver, new SchedulerClientName());
            return new StandardSchedulerClient(taskRepository);
        }
    }
}

