/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.Task;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskResolver {
    private static final Logger LOG = LoggerFactory.getLogger(TaskResolver.class);
    private final OnCannotResolve onCannotResolve;
    private final Map<String, Task> taskMap;

    public TaskResolver(List<Task> knownTasks, OnCannotResolve onCannotResolve) {
        this.onCannotResolve = onCannotResolve;
        this.taskMap = knownTasks.stream().collect(Collectors.toMap(Task::getName, Function.identity()));
    }

    public Task resolve(String taskName) {
        Task task = this.taskMap.get(taskName);
        if (task == null) {
            if (this.onCannotResolve == OnCannotResolve.FAIL_ON_UNRESOLVED) {
                throw new RuntimeException("Unable to resolve task with name " + taskName + ".");
            }
            LOG.warn("Found execution with unknown task-name '{}'", (Object)taskName);
            return null;
        }
        return task;
    }

    public void addTask(Task task) {
        this.taskMap.put(task.getName(), task);
    }

    public static enum OnCannotResolve {
        WARN_ON_UNRESOLVED,
        FAIL_ON_UNRESOLVED;

    }
}

