/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.TaskInstance;
import java.time.LocalDateTime;
import java.util.Objects;

public final class Execution {
    public final TaskInstance taskInstance;
    public final LocalDateTime executionTime;
    public boolean picked;
    public String pickedBy;
    public LocalDateTime lastHeartbeat;
    public long version;

    public Execution(LocalDateTime executionTime, TaskInstance taskInstance) {
        this(executionTime, taskInstance, false, null, null, 1L);
    }

    public Execution(LocalDateTime executionTime, TaskInstance taskInstance, boolean picked, String pickedBy, LocalDateTime lastHeartbeat, long version) {
        this.executionTime = executionTime;
        this.taskInstance = taskInstance;
        this.picked = picked;
        this.pickedBy = pickedBy;
        this.lastHeartbeat = lastHeartbeat;
        this.version = version;
    }

    public void setPicked(String pickedBy, LocalDateTime timePicked) {
        this.pickedBy = pickedBy;
        this.picked = true;
        this.lastHeartbeat = timePicked;
    }

    public LocalDateTime getExecutionTime() {
        return this.executionTime;
    }

    public boolean isPicked() {
        return this.picked;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Execution execution = (Execution)o;
        return Objects.equals(this.executionTime, execution.executionTime) && Objects.equals(this.taskInstance, execution.taskInstance);
    }

    public int hashCode() {
        return Objects.hash(this.executionTime, this.taskInstance);
    }

    public String toString() {
        return "Execution: task=" + this.taskInstance.getTask().getName() + ", id=" + this.taskInstance.getId() + ", executionTime=" + this.executionTime + ", picked=" + this.picked + ", pickedBy=" + this.pickedBy + ", lastHeartbeat=" + this.lastHeartbeat + ", version=" + this.version;
    }
}

